# Check for 64-bit host
if [ "`uname -m|grep _64`" = "" ] ; then
	echo "This program can only be installed under 64-bit Linux"
	exit 1
fi

# Check for access rights
if [ "`whoami`" != "root" ] ; then
	echo "Superuser privileges required"
	exit 1
fi

# Set default installation path
DEFAULT_TARGET_DIR=/opt/hifusion4.3

# Detect current absolute path
CMD="$0"
THIS_DIR="`pwd`"
ABS_PATH=`echo $CMD | awk '{
	if(substr($0, 1, 1) == "/")
		print $0;
	else
		print "'"$THIS_DIR"'/"$0;
	}'`

# Check if installation archive is present in the same directory
ROOT_DIR=`dirname "$ABS_PATH"`
if [ ! -f "$ROOT_DIR"/hifusion.tgz ] ; then
    echo "Please keep this script and the file hifusion.tgz in the same folder"
    exit 0
fi

# Begin installation
echo "********************************************************************************"
echo "*"
echo "* Welcome to HiFusion"
echo "*"
echo "* This script will install HiFusion 04.3.00 on your system."
echo "* You can abort the setup process anytime by pressing ctrl-c."
echo "*"
echo "********************************************************************************"
echo
if [ "$CONTINUE" != "y" ] ; then
	echo "Do you wish to continue? [y]es, [n]o (default=no)"
	read CONTINUE
	if [ "$CONTINUE" != "y" ] ; then
    exit 0
	fi
fi
echo

# Create default folder if does not yet exist
if [ "$TARGET_DIR" != "" ] ; then
	mkdir -p "$TARGET_DIR"
fi

# Read valid installation path from user
while [ ! -d "$TARGET_DIR" ] ; do
    echo "Please select a destination directory for the installation (default="$DEFAULT_TARGET_DIR")"
    read TARGET_DIR

    if [ "$TARGET_DIR" = "" ] ; then
        TARGET_DIR=$DEFAULT_TARGET_DIR
    fi

    if [ "$TARGET_DIR" = "/" ] ; then
				echo "Installing to the root directory is potentially dangerous and therefore forbidden."
        TARGET_DIR=
    fi

		if [ "$TARGET_DIR" != "" ] ; then
			if [ -d "$TARGET_DIR" ] ; then
				echo
				echo "*** Warning: The directory $TARGET_DIR already exists. ***"
				echo "Do you wish to continue? [y]es, [n]o (default=no)"
				read CONTINUE_TARGET_DIR
				if [ "$CONTINUE_TARGET_DIR" != "y" ] ; then
					TARGET_DIR=
				fi
			else
				if [ "$TARGET_DIR" != "$DEFAULT_TARGET_DIR" ] ; then
					echo "Installing to the directory $TARGET_DIR"
					echo "Do you wish to continue? [y]es, [n]o (default=yes)"
					read CREATE_TARGET_DIR
					if [ "$CREATE_TARGET_DIR" = "n" ] ; then
						TARGET_DIR=
					fi
				fi
				if [ "$TARGET_DIR" != "" ] ; then
					mkdir -p "$TARGET_DIR"
				fi
			fi
		fi
done

# Extract files, setup script and set permissions
echo
echo "Unpacking HiFusion 04.3.00 ..."
cd "$TARGET_DIR"
tar xzpf "$ROOT_DIR"/hifusion.tgz

cd lib



#
# this snippet extracts a gziped tar file containing JREs archived under a root directory

ARCH_LIST="amd64"
for JRE_ARCH in $ARCH_LIST ; do
	if [ "$JRE_ARCH" = "amd64" ] ; then
		OPENJDK_ARCH="x64"
	elif [ "$JRE_ARCH" = "i386" ] ; then
		OPENJDK_ARCH="x86-32"
	else
		OPENJDK_ARCH="$JRE_ARCH"
	fi
	tar xzpf OpenJDK8U-jre_"$OPENJDK_ARCH"_linux_hotspot_8u352b08.tar.gz
	mv jdk8u352-b08-jre java_$JRE_ARCH
	rm OpenJDK8U-jre_"$OPENJDK_ARCH"_linux_hotspot_8u352b08.tar.gz
	mv $JRE_ARCH/oslib java_$JRE_ARCH
	rmdir $JRE_ARCH
	mkdir -p java_$JRE_ARCH/lib/fonts/fallback
	cp Cyberbit.ttf java_$JRE_ARCH/lib/fonts/fallback
	chown -R 0:0 java_$JRE_ARCH


#	sed -i -E "s/^jdk.certpath.disabledAlgorithms=.*/\0, DSA/" java_$JRE_ARCH/lib/security/java.security
#	sed -i -E "s/^(jdk.tls.disabledAlgorithms=.*)(DH keySize < 768)(.*)/\1DH keySize < 1024\3, DSA, DESede/" java_$JRE_ARCH/lib/security/java.security
done
rm Cyberbit.ttf

cd ..

# Give some help on commands
echo "********************************************************************************"
echo "*"
echo "* HiFusion 04.3.00 is now installed and ready for use."
echo "*"
echo "* the application can be started with the command"
echo "*      $TARGET_DIR/bin/HiFusion"
echo "*"
echo "********************************************************************************"
