#!/bin/sh
# Determine installation folder
cmd=$0
thisDir=`pwd`
absDir=`echo $cmd | awk '{
if(substr($0, 1, 1) == "/")
    print $0;
else
    print "'"$thisDir"'/"$0;
}'`
baseDir=`dirname "$absDir"`
cd "$baseDir"

# Check OS architecture
is64bit=`uname -m|grep 64`
if [ "$is64bit" != "" ] ; then
	osArch=x64
else
	osArch=i586
fi

# Launch application
javaExe=jre_$osArch/bin/java
"$javaExe" -jar AppletLauncher.jar $*
