# Initial defaults
CONTINUE=""
TARGET_DIR=""
ENABLE_REMOTE=""
ENABLE_IMPORT="n"

# Check for 64-bit host
if [ "`uname -m|grep _64`" = "" ] ; then
	echo "This program can only be installed under 64-bit Linux"
	exit 1
fi

# Check for access rights
if [ "`whoami`" != "root" ] ; then
	echo "Superuser privileges required"
	exit 1
fi

# Set default installation path
DEFAULT_TARGET_DIR=/opt/ihivision8.1

# Detect current absolute path
CMD="$0"
THIS_DIR="`pwd`"
ABS_PATH=`echo $CMD | awk '{
	if(substr($0, 1, 1) == "/")
		print $0;
	else
		print "'"$THIS_DIR"'/"$0;
	}'`

# Check if installation archive is present in the same directory
ROOT_DIR=`dirname "$ABS_PATH"`
if [ ! -f "$ROOT_DIR"/ihivision.tgz ] ; then
    echo "Please keep this script and the file ihivision.tgz in the same folder"
    exit 0
fi

# Begin installation
echo "********************************************************************************"
echo "*"
echo "* Welcome to Industrial HiVision"
echo "*"
echo "* This script will install Industrial HiVision 08.1.04 on your system."
echo "* You can abort the setup process anytime by pressing ctrl-c."
echo "*"
echo "********************************************************************************"
echo
if [ "$CONTINUE" != "y" ] ; then
	echo "Do you wish to continue? [y]es, [n]o (default=no)"
	read CONTINUE
	if [ "$CONTINUE" != "y" ] ; then
    exit 0
	fi
fi
echo

# Create default folder if does not yet exist
if [ "$TARGET_DIR" != "" ] ; then
	mkdir -p "$TARGET_DIR"
fi

# Read valid installation path from user
while [ ! -d "$TARGET_DIR" ] ; do
    echo "Please select a destination directory for the installation (default="$DEFAULT_TARGET_DIR")"
    read TARGET_DIR

    if [ "$TARGET_DIR" = "" ] ; then
        TARGET_DIR=$DEFAULT_TARGET_DIR
    fi

    if [ "$TARGET_DIR" = "/" ] ; then
				echo "Installing to the root directory is potentially dangerous and therefore forbidden."
        TARGET_DIR=
    fi

		if [ "$TARGET_DIR" != "" ] ; then
			if [ -d "$TARGET_DIR" ] ; then
				echo
				echo "*** Warning: The directory $TARGET_DIR already exists. ***"
				echo "Do you wish to continue? [y]es, [n]o (default=no)"
				read CONTINUE_TARGET_DIR
				if [ "$CONTINUE_TARGET_DIR" != "y" ] ; then
					TARGET_DIR=
				fi
			else
				if [ "$TARGET_DIR" != "$DEFAULT_TARGET_DIR" ] ; then
					echo "Installing to the directory $TARGET_DIR"
					echo "Do you wish to continue? [y]es, [n]o (default=yes)"
					read CREATE_TARGET_DIR
					if [ "$CREATE_TARGET_DIR" = "n" ] ; then
						TARGET_DIR=
					fi
				fi
				if [ "$TARGET_DIR" != "" ] ; then
					mkdir -p "$TARGET_DIR"
				fi
			fi
		fi
done

# Extract files, setup script and set permissions
echo
echo "Unpacking Industrial HiVision 08.1.04 ..."
cd "$TARGET_DIR"
tar xzpf "$ROOT_DIR"/ihivision.tgz
chmod 777 log/services
# set write access to var for unpacking the HiConfig starters
chmod 777 var 

cd lib



#
# this snippet extracts a gziped tar file containing JREs archived under a root directory

ARCH_LIST="amd64"
for JRE_ARCH in $ARCH_LIST ; do
	tar xzpf jre8u302b08-linux-$JRE_ARCH.tar.gz
	mv jdk8u302-b08-jre java_$JRE_ARCH
	rm jre8u302b08-linux-$JRE_ARCH.tar.gz
	mv $JRE_ARCH/oslib java_$JRE_ARCH
	rmdir $JRE_ARCH
	mkdir -p java_$JRE_ARCH/lib/fonts/fallback
	cp Cyberbit.ttf java_$JRE_ARCH/lib/fonts/fallback
	chown -R 0:0 java_$JRE_ARCH


#	sed -i -E "s/^jdk.certpath.disabledAlgorithms=.*/\0, DSA/" java_$JRE_ARCH/lib/security/java.security
#	sed -i -E "s/^(jdk.tls.disabledAlgorithms=.*)(DH keySize < 768)(.*)/\1DH keySize < 1024\3, DSA, DESede/" java_$JRE_ARCH/lib/security/java.security
done
rm Cyberbit.ttf

cd ..

echo
echo "Running setup script..."
./setup.sh
mv setup.sh setup.bak
chmod 644 setup.bak
echo

# Set default settings
if [ "$ENABLE_REMOTE" = "" ] ; then
	echo "Would you like to enable remote access by default? [y]es, [n]o (default=no)"
	read ENABLE_REMOTE
	if [ "$ENABLE_REMOTE" = "y" ] ; then
		mkdir -p "$TARGET_DIR"/config
		echo "AllowRemote=true" > "$TARGET_DIR"/config/ProxyService.properties
	fi
fi
echo

# Check presence of previous releases
VERSION_IMPORT_DIR=
PREV_DEFAULT_DIRS="/opt/ihivision8.0 /opt/ihivision7.1 /opt/ihivision7.0 /opt/ihivision6.0 /opt/ihivision5.1 /opt/ihivision5.0 /opt/ihivision04403 /opt/ihivision04402 /opt/ihivision04401 /opt/ihivision04400 /opt/ihivision04300 /opt/ihivision04201 /opt/ihivision04200 /opt/ihivision04100 /opt/ihivision400 /opt/ihivision310 /opt/ihivision302 /opt/ihivision301 /opt/ihivision300 /opt/ihivision200 /opt/ihivision100"

for INST_DIR in $PREV_DEFAULT_DIRS ; do
	if [ -d "$INST_DIR" ] ; then
		VERSION_IMPORT_DIR="$INST_DIR"
		break;
	fi
done

# Ask for importing data from previous releases
if [ "$VERSION_IMPORT_DIR" != "" ] ; then
	echo "Would you like to import data from previous releases? [y]es, [n]o (default=no)"
	read ENABLE_IMPORT
fi

if [ "$ENABLE_IMPORT" = "y" ] ; then
	# Import database from previous releases
	if [ "$VERSION_IMPORT_DIR" = "" ] ; then
		echo "Please select the installation directory of an installed Industrial HiVision"
		echo "or <RETURN> if this is the first installation"
		read VERSION_IMPORT_DIR
	fi

	if [ -d "$VERSION_IMPORT_DIR" ] ; then
		echo

		echo "Importing config data from ""$VERSION_IMPORT_DIR/config"
		cp -f "$VERSION_IMPORT_DIR"/config/*Service.properties ./config
		cp -f "$VERSION_IMPORT_DIR/config/presets.xml" ./config
		cp -f "$VERSION_IMPORT_DIR/config/usermanagement.xml" ./config

		if [ -d "$VERSION_IMPORT_DIR/config/licenses" ] ; then
			echo "Importing licenses from ""$VERSION_IMPORT_DIR/config/licenses"
			cp -R "$VERSION_IMPORT_DIR/config/licenses" ./config
			echo
		fi

		if [ -d "$VERSION_IMPORT_DIR/report_db" ] ; then
			echo "Importing reporting databases from ""$VERSION_IMPORT_DIR/report_db"
			cp -Rf "$VERSION_IMPORT_DIR/report_db" ./report_db
			echo
		fi

		if [ -d "$VERSION_IMPORT_DIR/var" ] ; then
			echo "Importing work data from ""$VERSION_IMPORT_DIR/var"
			cp -Rf "$VERSION_IMPORT_DIR/var" ./var
			echo
		fi

    if [ -d "$VERSION_IMPORT_DIR/database" ] ; then
			echo "Importing database from ""$VERSION_IMPORT_DIR/database"
			echo
			echo "Please stop the Industrial HiVision service from which you would like to import data before continuing."
			echo "Importing from a running service will result in a corrupt database."
			echo "Press <RETURN> to continue"
			read dummy
			echo
			echo "Copying database..."
			cp -Rfp $VERSION_IMPORT_DIR/database .
			echo
    fi
	fi
fi

# Remove suffix from init script
SYSV_INIT_FILE=`basename ihivision8.1.initd .initd`

# Give some help on commands
echo "********************************************************************************"
echo "*"
echo "* Industrial HiVision 08.1.04 is now installed and ready for use."
echo "*"
echo "* the services can be started/stopped by the root user with the command"
echo "*      /etc/init.d/$SYSV_INIT_FILE start|stop"
echo "* the graphical application can be started by any user with the command"
echo "*      $TARGET_DIR/bin/HiVision"
echo "*"
echo "********************************************************************************"
echo "Press <RETURN> to finish"
read dummy
