package net.sf.expectit;

/*
 * #%L
 * ExpectIt
 * %%
 * Copyright (C) 2014 Alexey Gavrilov and contributors
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

/**
 * An executor thread factory which adds a prefix to the default thread name generated by
 * {@link java.util.concurrent.Executors#defaultThreadFactory()}.
 */
final class NamedExecutorThreadFactory implements ThreadFactory {
    private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private final String prefix;

    /**
     * Constructor.
     *
     * @param prefix the string to prepend to the default thread name.
     */
    NamedExecutorThreadFactory(String prefix) {
        this.prefix = prefix;
    }

    @Override
    public Thread newThread(Runnable target) {
        Thread thread = defaultFactory.newThread(target);
        thread.setName(prefix + thread.getName());
        return thread;
    }
}
