/**
 *
 * @author Bela Ban Nov 25, 2003
 * @version $Id: IsolationLevel.java,v 1.3 2005/02/25 19:52:49 belaban Exp $
 */
package org.jboss.cache.lock;

public class IsolationLevel
{
   public static final IsolationLevel NONE = new IsolationLevel("NONE");
   public static final IsolationLevel SERIALIZABLE = new IsolationLevel("SERIALIZABLE");
   public static final IsolationLevel REPEATABLE_READ = new IsolationLevel("REPEATABLE_READ");
   public static final IsolationLevel READ_COMMITTED = new IsolationLevel("READ_COMMITTED");
   public static final IsolationLevel READ_UNCOMMITTED = new IsolationLevel("READ_UNCOMMITTED");
   public static final IsolationLevel BELA = new IsolationLevel("BELA");

   private final String myName; // for debug only

   private IsolationLevel(String name)
   {
      myName = name;
   }

   public String toString()
   {
      return myName;
   }

   public static IsolationLevel stringToIsolationLevel(String level)
   {
      if (level == null) return null;
      level = level.toLowerCase().trim();
      if (level.equals("none")) return NONE;
      if (level.equals("serializable")) return SERIALIZABLE;
      if (level.equals("repeatable_read") || level.equals("repeatable-read")) return REPEATABLE_READ;
      if (level.equals("read_committed") || level.equals("read-committed")) return READ_COMMITTED;
      if (level.equals("read_uncommitted") || level.equals("read-uncommitted")) return READ_UNCOMMITTED;
      if (level.equals("bela")) return BELA;
      return null;
   }
}
