package junit.extensions.jfcunit.eventdata;

import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.RobotTestHelper;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.jfcunit.xml.JFCXMLTestCase;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.elements.AbstractTagHandler;

import org.w3c.dom.Element;

import java.awt.AWTException;


/**
 * This class will handle the processing of &lt;click&gt; nodes.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class ClickTagHandler extends AbstractTagHandler
    implements JFCXMLConstants {
    /**
     * Robot test helper used to submit events.
     */
    private static TestHelper s_robotTestHelper;

    /**
     * JFCTEst Helper used to submit events.
     */
    private static TestHelper s_jfcTestHelper;

    /**
     * Constructor for ClickTagHandler.
     *
     * @param element     The element to be processed.
     * @param testCase    The IXMLTestCase that uses this element.
     */
    public ClickTagHandler(final Element element, final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement().
     */
    public void processElement() throws XMLException {
        validateElement();

        BaseEventDataTagHandler th = (BaseEventDataTagHandler) XMLTagResourceBundle
            .getTagHandler(
                getElement(),
                getXMLTestCase(),
                getType());

        Object                  robot = getXMLTestCase().getProperty(ROBOT);

        if (robot == null) {
            ((JFCXMLTestCase) getTestCase()).getHelper().enterClickAndLeave(
                th.getEventData());

            return;
        }

        if (robot instanceof String) {
            robot = Boolean.valueOf((String) robot);
        }

        Object sstep = getXMLTestCase().getProperty("step");

        int    step = -1;

        if (sstep instanceof String) {
            step = Integer.parseInt((String) sstep);
        }

        if (((Boolean) robot).equals(Boolean.TRUE)) {
            if (step != -1) {
                getRobotTestHelper().setStep(step);
            }

            getRobotTestHelper().enterClickAndLeave(th.getEventData());
        } else {
            if (step != -1) {
                getJFCTestHelper().setStep(step);
            }

            getJFCTestHelper().enterClickAndLeave(th.getEventData());
        }
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement().
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // Only one of the following is required.
        checkRequiredAttribute(TYPE);
    }

    /**
     * Returns the value of the TYPE attribute for this element.
     * @return String  The value of the TYPE attribute.
     */
    protected String getType() {
        return getString(TYPE);
    }

    /**
     * Get a JFCTestHelper.
     * @return jfcTestHelper
     */
    private TestHelper getJFCTestHelper() {
        if (s_jfcTestHelper == null) {
            s_jfcTestHelper = new JFCTestHelper();
        }

        return s_jfcTestHelper;
    }

    /**
     * Get a RobotTestHelper instance if possible.
     * @return robot test helper. If the robot test
     * helper cannot be instanciated then the jfctesthelper is
     * returned.
     */
    private TestHelper getRobotTestHelper() {
        if (s_robotTestHelper == null) {
            try {
                s_robotTestHelper = new RobotTestHelper();
            } catch (AWTException ex) {
                ex.printStackTrace();
                System.err.println("Error creating Robot using JFCTestHelper");
                s_robotTestHelper = getJFCTestHelper();
            }
        }

        return s_robotTestHelper;
    }
}
