package junit.extensions.jfcunit.eventdata;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;

import javax.swing.JList;


/**
 * This is a extension of the click and drag elements. Where the
 * type specified is JListMouseEventData.
 *
 * <h3>Description</h3>
 * <p>
 *   Nothing is invoked directly by this tag handler. The click and drag elements
 *   use this tag handler to customize the data specificly for the type specified.
 * </p>
 * <p>
 *   For now this class requires the index. It does not yet provide methods for
 *   searching for tabs based upon the text or icon contained. These are left
 *   for future enhancements.
 * </p>
 *
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">type</td>
 *     <td valign="top">For this element the type must be set to MouseEventData</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">Id of a object reference which has been previously found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">The index of the element to select from the list.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">-1</td>
 *     <td valign="top">Zero based index of list items.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">clicks</td>
 *     <td valign="top">The number of clicks to be executed.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">1</td>
 *     <td valign="top">Positive Integer</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">modifiers</td>
 *     <td valign="top">The modifiers to be used for this event.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Button1 if popup is false otherwise Button3</td>
 *     <td valign="top">alt altgr control meta shift button1 button2 button3</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">popup</td>
 *     <td valign="top">True if this is event is using the popup button.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true false</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">sleeptime</td>
 *     <td valign="top">Maximum sleep time</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">500</td>
 *     <td valign="top">Positive Integer representing the milli-seconds</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">position</td>
 *     <td valign="top">Positioning of the mouse within the bounds of the component.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">center</td>
 *     <td valign="top">center north northeast east southeast south southwest west northwest custom percentage</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">reference</td>
 *     <td valign="top">Reference point or number for position calculation.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">null</td>
 *     <td valign="top">integers &quot;x,y&quot;</td>
 *   </tr>
 *
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;click
 *    type=&quot;JListMouseEventData&quot;
 *    refid=&quot;List&quot;
 *    index=&quot;1&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above clicks once on the center of the component identified by
 * List.
 * </p>
 * @see junit.extensions.jfcunit.eventdata.JListMouseEventData
 * @author Kevin Wilson
 */
public class JListMouseEventDataTagHandler extends BaseEventDataTagHandler {
    /**
     * Constructor for JListMouseEventDataTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public JListMouseEventDataTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException when validation fails.
     */
    public void processElement() throws XMLException {
        validateElement();
        setEventData(
            new JListMouseEventData(
                getJFCTestCase(),
                (JList) getComponent(),
                getIndex(),
                getClicks(),
                getModifiers(),
                getPopupTrigger(),
                getSleepTime(),
                getPosition(),
                getReference()));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        /**
         * @todo Should be able to find the object to select.
         * For now we will require the index.
         * index into combo box.
         */
        checkRequiredAttribute(INDEX);
    }

    /**
     * Returns the value of the INDEX attribute for this element. Defaults to 0 (zero) if not found.
     * @return int  The value of the parsed INDEX attribute, zero if not found.
     */
    private int getIndex() {
        try {
            return getInt(INDEX, 0);
        } catch (NumberFormatException e) {
            throw new NumberFormatException("Index not formatted properly");
        }
    }
}
