package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;


/**
 * This is a extension of the findTagHandler element. Where the
 * finder specified is DialogFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a DialogFinder and executes the find.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * DialogFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to DialogFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">title</td>
 *     <td valign="top">The title of the dialog to be found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">None</td>
 *     <td valign="top">Regular expression defining the title.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">caseindependent</td>
 *     <td valign="top">Ignore the case if true</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true/false</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;DialogFinder&quot;
 *    id=&quot;MyDialog&quot;
 *    title=&quot;^My dialog box$&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the first dialog with
 * a complete title &quot;My dialog box&quot;
 * </p>
 * @see junit.extensions.jfcunit.finder.DialogFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class DialogFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for ComponentFinderTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public DialogFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     */
    public void processElement() throws XMLException {
        validateElement();
        findWindow(new DialogFinder(
                getTitle(),
                getCaseIndependent()));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: class
        checkRequiredAttribute(TITLE);
    }

    /**
     * Get the Wait time for the finder.
     * @return Duration for the Finder to try again until the
     * object is found.
     */
    protected int getWait() {
        return super.getInt(WAIT, 15);
    }
}
