package junit.extensions.jfcunit.finder;

import java.awt.Component;

import javax.swing.JPopupMenu;


/**
 * <p>Title: Find a popup menu given the invoker.</p>
 * <p>Description: Locate the popup menu associated
 * with the invoker. </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: JFCUnit OpenSource Project</p>
 * @author Kevin Wilson
 * @version 1.0
 */
public class JPopupMenuFinder extends Finder {
    /**
     * The Invoker of the Popup Menu.
     */
    private Component m_invoker;

    /**
     * Constructor.
     * @param invoker Component which is used to determine
     * which menu to return.
     */
    public JPopupMenuFinder(final Component invoker) {
        setInvoker(invoker);
        setWait(2);
    }

    /**
     * Set the invoker to be matched.
     * @param invoker Component invoker to be matched.
     */
    public final void setInvoker(final Component invoker) {
        m_invoker = invoker;
    }

    /**
     * Get the invoker to be matched.
     * @return Component invoker to be matched.
     */
    public final Component getInvoker() {
        return m_invoker;
    }

    /**
     * For JPopupMenu components validate return all
     * Components with the invoker.
     * @param comp Component to be tested.
     * @return boolean true if the invokers of the JPopupMenu
     * matches the invoker passed in the constructor.
     */
    public boolean testComponent(final Component comp) {
        if (isValidForProcessing(comp, JPopupMenu.class)) {
            return m_invoker.equals(((JPopupMenu) (comp)).getInvoker());
        }

        return false;
    }
}
