package junit.extensions.jfcunit.keyboard;

import java.awt.event.KeyEvent;


/**
 * This class maps the key codes for a standard
 * US 101 Key Keyboard.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class DefaultKeyMapping extends AbstractKeyMapping {
    /**
     * Create a local Mapping for the shift key.
     */
    private static final int SHIFT = KeyEvent.SHIFT_MASK;

    /**
     * The array below maps the character code to
     * the key codes which are to be struck to
     * construct the character.
     */
    private static final Object[][] CHARMAP = new Object[][] {
            {
                new Character(' '),
                new JFCKeyStroke(' ', KeyEvent.VK_SPACE, 0, true)
            },
            {
                new Character('\n'),
                new JFCKeyStroke('\n', KeyEvent.VK_ENTER, 0, true)
            },
            {
                new Character('\b'),
                new JFCKeyStroke('\b', KeyEvent.VK_BACK_SPACE, 0, true)
            },
            {
                new Character('\t'),
                new JFCKeyStroke('\t', KeyEvent.VK_TAB, 0, true)
            },
            {
                new Character('\u0001'),
                new JFCKeyStroke('\u0001', KeyEvent.VK_A, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0002'),
                new JFCKeyStroke('\u0002', KeyEvent.VK_B, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0003'),
                new JFCKeyStroke('\u0003', KeyEvent.VK_C, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0004'),
                new JFCKeyStroke('\u0004', KeyEvent.VK_D, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0005'),
                new JFCKeyStroke('\u0005', KeyEvent.VK_E, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0006'),
                new JFCKeyStroke('\u0006', KeyEvent.VK_F, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0007'),
                new JFCKeyStroke('\u0007', KeyEvent.VK_G, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0008'),
                new JFCKeyStroke('\u0008', KeyEvent.VK_H, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0009'),
                new JFCKeyStroke('\t', KeyEvent.VK_TAB, 0, true)
            },
            {
                new Character('\r'),
                new JFCKeyStroke('\r', KeyEvent.VK_J, KeyEvent.CTRL_MASK, true)
            },
            {
                new Character('\u000b'),
                new JFCKeyStroke('\u000b', KeyEvent.VK_K, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u000c'),
                new JFCKeyStroke('\u000c', KeyEvent.VK_L, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\r'),
                new JFCKeyStroke('\r', KeyEvent.VK_M, KeyEvent.CTRL_MASK, true)
            },
            {
                new Character('\u000e'),
                new JFCKeyStroke('\u000e', KeyEvent.VK_N, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u000f'),
                new JFCKeyStroke('\u000f', KeyEvent.VK_O, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0010'),
                new JFCKeyStroke('\u0010', KeyEvent.VK_P, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0011'),
                new JFCKeyStroke('\u0011', KeyEvent.VK_Q, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0012'),
                new JFCKeyStroke('\u0012', KeyEvent.VK_R, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0013'),
                new JFCKeyStroke('\u0013', KeyEvent.VK_S, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0014'),
                new JFCKeyStroke('\u0014', KeyEvent.VK_T, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0015'),
                new JFCKeyStroke('\u0015', KeyEvent.VK_U, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0016'),
                new JFCKeyStroke('\u0016', KeyEvent.VK_V, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0017'),
                new JFCKeyStroke('\u0017', KeyEvent.VK_W, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0018'),
                new JFCKeyStroke('\u0018', KeyEvent.VK_X, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u0019'),
                new JFCKeyStroke('\u0019', KeyEvent.VK_Y, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Character('\u001a'),
                new JFCKeyStroke('\u001a', KeyEvent.VK_Z, KeyEvent.CTRL_MASK,
                    true)
            },
            {new Character('a'), new JFCKeyStroke('a', KeyEvent.VK_A, 0, true)},
            {new Character('b'), new JFCKeyStroke('b', KeyEvent.VK_B, 0, true)},
            {new Character('c'), new JFCKeyStroke('c', KeyEvent.VK_C, 0, true)},
            {new Character('d'), new JFCKeyStroke('d', KeyEvent.VK_D, 0, true)},
            {new Character('e'), new JFCKeyStroke('e', KeyEvent.VK_E, 0, true)},
            {new Character('f'), new JFCKeyStroke('f', KeyEvent.VK_F, 0, true)},
            {new Character('g'), new JFCKeyStroke('g', KeyEvent.VK_G, 0, true)},
            {new Character('h'), new JFCKeyStroke('h', KeyEvent.VK_H, 0, true)},
            {new Character('i'), new JFCKeyStroke('i', KeyEvent.VK_I, 0, true)},
            {new Character('j'), new JFCKeyStroke('j', KeyEvent.VK_J, 0, true)},
            {new Character('k'), new JFCKeyStroke('k', KeyEvent.VK_K, 0, true)},
            {new Character('l'), new JFCKeyStroke('l', KeyEvent.VK_L, 0, true)},
            {new Character('m'), new JFCKeyStroke('m', KeyEvent.VK_M, 0, true)},
            {new Character('n'), new JFCKeyStroke('n', KeyEvent.VK_N, 0, true)},
            {new Character('o'), new JFCKeyStroke('o', KeyEvent.VK_O, 0, true)},
            {new Character('p'), new JFCKeyStroke('p', KeyEvent.VK_P, 0, true)},
            {new Character('q'), new JFCKeyStroke('q', KeyEvent.VK_Q, 0, true)},
            {new Character('r'), new JFCKeyStroke('r', KeyEvent.VK_R, 0, true)},
            {new Character('s'), new JFCKeyStroke('s', KeyEvent.VK_S, 0, true)},
            {new Character('t'), new JFCKeyStroke('t', KeyEvent.VK_T, 0, true)},
            {new Character('u'), new JFCKeyStroke('u', KeyEvent.VK_U, 0, true)},
            {new Character('v'), new JFCKeyStroke('v', KeyEvent.VK_V, 0, true)},
            {new Character('w'), new JFCKeyStroke('w', KeyEvent.VK_W, 0, true)},
            {new Character('x'), new JFCKeyStroke('x', KeyEvent.VK_X, 0, true)},
            {new Character('y'), new JFCKeyStroke('y', KeyEvent.VK_Y, 0, true)},
            {new Character('z'), new JFCKeyStroke('z', KeyEvent.VK_Z, 0, true)},
            {
                new Character('A'),
                new JFCKeyStroke('A', KeyEvent.VK_A, SHIFT, true)
            },
            {
                new Character('B'),
                new JFCKeyStroke('B', KeyEvent.VK_B, SHIFT, true)
            },
            {
                new Character('C'),
                new JFCKeyStroke('C', KeyEvent.VK_C, SHIFT, true)
            },
            {
                new Character('D'),
                new JFCKeyStroke('D', KeyEvent.VK_D, SHIFT, true)
            },
            {
                new Character('E'),
                new JFCKeyStroke('E', KeyEvent.VK_E, SHIFT, true)
            },
            {
                new Character('F'),
                new JFCKeyStroke('F', KeyEvent.VK_F, SHIFT, true)
            },
            {
                new Character('G'),
                new JFCKeyStroke('G', KeyEvent.VK_G, SHIFT, true)
            },
            {
                new Character('H'),
                new JFCKeyStroke('H', KeyEvent.VK_H, SHIFT, true)
            },
            {
                new Character('I'),
                new JFCKeyStroke('I', KeyEvent.VK_I, SHIFT, true)
            },
            {
                new Character('J'),
                new JFCKeyStroke('J', KeyEvent.VK_J, SHIFT, true)
            },
            {
                new Character('K'),
                new JFCKeyStroke('K', KeyEvent.VK_K, SHIFT, true)
            },
            {
                new Character('L'),
                new JFCKeyStroke('L', KeyEvent.VK_L, SHIFT, true)
            },
            {
                new Character('M'),
                new JFCKeyStroke('M', KeyEvent.VK_M, SHIFT, true)
            },
            {
                new Character('N'),
                new JFCKeyStroke('N', KeyEvent.VK_N, SHIFT, true)
            },
            {
                new Character('O'),
                new JFCKeyStroke('O', KeyEvent.VK_O, SHIFT, true)
            },
            {
                new Character('P'),
                new JFCKeyStroke('P', KeyEvent.VK_P, SHIFT, true)
            },
            {
                new Character('Q'),
                new JFCKeyStroke('Q', KeyEvent.VK_Q, SHIFT, true)
            },
            {
                new Character('R'),
                new JFCKeyStroke('R', KeyEvent.VK_R, SHIFT, true)
            },
            {
                new Character('S'),
                new JFCKeyStroke('S', KeyEvent.VK_S, SHIFT, true)
            },
            {
                new Character('T'),
                new JFCKeyStroke('T', KeyEvent.VK_T, SHIFT, true)
            },
            {
                new Character('U'),
                new JFCKeyStroke('U', KeyEvent.VK_U, SHIFT, true)
            },
            {
                new Character('V'),
                new JFCKeyStroke('V', KeyEvent.VK_V, SHIFT, true)
            },
            {
                new Character('W'),
                new JFCKeyStroke('W', KeyEvent.VK_W, SHIFT, true)
            },
            {
                new Character('X'),
                new JFCKeyStroke('X', KeyEvent.VK_X, SHIFT, true)
            },
            {
                new Character('Y'),
                new JFCKeyStroke('Y', KeyEvent.VK_Y, SHIFT, true)
            },
            {
                new Character('Z'),
                new JFCKeyStroke('Z', KeyEvent.VK_Z, SHIFT, true)
            },

            {new Character('0'), new JFCKeyStroke('0', KeyEvent.VK_0, 0, true)},
            {new Character('1'), new JFCKeyStroke('1', KeyEvent.VK_1, 0, true)},
            {new Character('2'), new JFCKeyStroke('2', KeyEvent.VK_2, 0, true)},
            {new Character('3'), new JFCKeyStroke('3', KeyEvent.VK_3, 0, true)},
            {new Character('4'), new JFCKeyStroke('4', KeyEvent.VK_4, 0, true)},
            {new Character('5'), new JFCKeyStroke('5', KeyEvent.VK_5, 0, true)},
            {new Character('6'), new JFCKeyStroke('6', KeyEvent.VK_6, 0, true)},
            {new Character('7'), new JFCKeyStroke('7', KeyEvent.VK_7, 0, true)},
            {new Character('8'), new JFCKeyStroke('8', KeyEvent.VK_8, 0, true)},
            {new Character('9'), new JFCKeyStroke('9', KeyEvent.VK_9, 0, true)},

            {new Character(')'), new JFCKeyStroke(')', KeyEvent.VK_0, SHIFT,
                    true)},
            {
                new Character('!'),
                new JFCKeyStroke('!', KeyEvent.VK_1, SHIFT, true)
            },
            {
                new Character('@'),
                new JFCKeyStroke('@', KeyEvent.VK_2, SHIFT, true)
            },
            {
                new Character('#'),
                new JFCKeyStroke('#', KeyEvent.VK_3, SHIFT, true)
            },
            {
                new Character('$'),
                new JFCKeyStroke('$', KeyEvent.VK_4, SHIFT, true)
            },
            {
                new Character('%'),
                new JFCKeyStroke('%', KeyEvent.VK_5, SHIFT, true)
            },
            {
                new Character('^'),
                new JFCKeyStroke('^', KeyEvent.VK_6, SHIFT, true)
            },
            {
                new Character('&'),
                new JFCKeyStroke('&', KeyEvent.VK_7, SHIFT, true)
            },
            {
                new Character('*'),
                new JFCKeyStroke('*', KeyEvent.VK_8, SHIFT, true)
            },
            {
                new Character('('),
                new JFCKeyStroke('(', KeyEvent.VK_9, SHIFT, true)
            },

            {new Character('`'), new JFCKeyStroke('`', KeyEvent.VK_BACK_QUOTE,
                    0, true)},
            {
                new Character('~'),
                new JFCKeyStroke('~', KeyEvent.VK_BACK_QUOTE, SHIFT, true)
            },
            {
                new Character('-'),
                new JFCKeyStroke('-', KeyEvent.VK_MINUS, 0, true)
            },
            {
                new Character('_'),
                new JFCKeyStroke('_', KeyEvent.VK_MINUS, SHIFT, true)
            },
            {
                new Character('='),
                new JFCKeyStroke('=', KeyEvent.VK_EQUALS, 0, true)
            },
            {
                new Character('+'),
                new JFCKeyStroke('+', KeyEvent.VK_EQUALS, SHIFT, true)
            },
            {
                new Character('['),
                new JFCKeyStroke('[', KeyEvent.VK_OPEN_BRACKET, 0, true)
            },
            {
                new Character(']'),
                new JFCKeyStroke(']', KeyEvent.VK_CLOSE_BRACKET, 0, true)
            },
            {
                new Character('\\'),
                new JFCKeyStroke('\\', KeyEvent.VK_BACK_SLASH, 0, true)
            },
            {
                new Character('{'),
                new JFCKeyStroke('{', KeyEvent.VK_OPEN_BRACKET, SHIFT, true)
            },
            {
                new Character('}'),
                new JFCKeyStroke('}', KeyEvent.VK_CLOSE_BRACKET, SHIFT, true)
            },
            {
                new Character('|'),
                new JFCKeyStroke('|', KeyEvent.VK_BACK_SLASH, SHIFT, true)
            },
            {
                new Character(';'),
                new JFCKeyStroke(';', KeyEvent.VK_SEMICOLON, 0, true)
            },
            {
                new Character(':'),
                new JFCKeyStroke(':', KeyEvent.VK_SEMICOLON, SHIFT, true)
            },
            {
                new Character('\''),
                new JFCKeyStroke('\'', KeyEvent.VK_QUOTE, 0, true)
            },
            {
                new Character('"'),
                new JFCKeyStroke('"', KeyEvent.VK_QUOTE, SHIFT, true)
            },
            {
                new Character(','),
                new JFCKeyStroke(',', KeyEvent.VK_COMMA, 0, true)
            },
            {
                new Character('<'),
                new JFCKeyStroke('<', KeyEvent.VK_COMMA, SHIFT, true)
            },
            {
                new Character('.'),
                new JFCKeyStroke('.', KeyEvent.VK_PERIOD, 0, true)
            },
            {
                new Character('>'),
                new JFCKeyStroke('>', KeyEvent.VK_PERIOD, SHIFT, true)
            },
            {
                new Character('/'),
                new JFCKeyStroke('/', KeyEvent.VK_SLASH, 0, true)
            },
            {
                new Character('?'),
                new JFCKeyStroke('?', KeyEvent.VK_SLASH, SHIFT, true)
            },
            {
                new Integer(1),
                new JFCKeyStroke('\u0001', KeyEvent.VK_A, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(2),
                new JFCKeyStroke('\u0002', KeyEvent.VK_B, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(3),
                new JFCKeyStroke('\u0003', KeyEvent.VK_C, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(4),
                new JFCKeyStroke('\u0004', KeyEvent.VK_D, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(5),
                new JFCKeyStroke('\u0005', KeyEvent.VK_E, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(6),
                new JFCKeyStroke('\u0006', KeyEvent.VK_F, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(7),
                new JFCKeyStroke('\u0007', KeyEvent.VK_G, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(8),
                new JFCKeyStroke('\u0008', KeyEvent.VK_H, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(9),
                new JFCKeyStroke('\u0009', KeyEvent.VK_I, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(10),
                new JFCKeyStroke('\r', KeyEvent.VK_J, KeyEvent.CTRL_MASK, true)
            },
            {
                new Integer(11),
                new JFCKeyStroke('\u000b', KeyEvent.VK_K, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(12),
                new JFCKeyStroke('\u000c', KeyEvent.VK_L, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(13),
                new JFCKeyStroke('\r', KeyEvent.VK_M, KeyEvent.CTRL_MASK, true)
            },
            {
                new Integer(14),
                new JFCKeyStroke('\u000e', KeyEvent.VK_N, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(15),
                new JFCKeyStroke('\u000f', KeyEvent.VK_O, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(16),
                new JFCKeyStroke('\u0010', KeyEvent.VK_P, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(17),
                new JFCKeyStroke('\u0011', KeyEvent.VK_Q, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(18),
                new JFCKeyStroke('\u0012', KeyEvent.VK_R, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(19),
                new JFCKeyStroke('\u0013', KeyEvent.VK_S, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(20),
                new JFCKeyStroke('\u0014', KeyEvent.VK_T, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(21),
                new JFCKeyStroke('\u0015', KeyEvent.VK_U, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(22),
                new JFCKeyStroke('\u0016', KeyEvent.VK_V, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(23),
                new JFCKeyStroke('\u0017', KeyEvent.VK_W, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(24),
                new JFCKeyStroke('\u0018', KeyEvent.VK_X, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(25),
                new JFCKeyStroke('\u0019', KeyEvent.VK_Y, KeyEvent.CTRL_MASK,
                    true)
            },
            {
                new Integer(26),
                new JFCKeyStroke('\u001a', KeyEvent.VK_Z, KeyEvent.CTRL_MASK,
                    true)
            },
            {new Integer(KeyEvent.VK_A), new JFCKeyStroke('a', 65, 0, true)},
            {new Integer(KeyEvent.VK_B), new JFCKeyStroke('b', 66, 0, true)},
            {new Integer(KeyEvent.VK_C), new JFCKeyStroke('c', 67, 0, true)},
            {new Integer(KeyEvent.VK_D), new JFCKeyStroke('d', 68, 0, true)},
            {new Integer(KeyEvent.VK_E), new JFCKeyStroke('e', 69, 0, true)},
            {new Integer(KeyEvent.VK_F), new JFCKeyStroke('f', 70, 0, true)},
            {new Integer(KeyEvent.VK_G), new JFCKeyStroke('g', 71, 0, true)},
            {new Integer(KeyEvent.VK_H), new JFCKeyStroke('h', 72, 0, true)},
            {new Integer(KeyEvent.VK_I), new JFCKeyStroke('i', 73, 0, true)},
            {new Integer(KeyEvent.VK_J), new JFCKeyStroke('j', 74, 0, true)},
            {new Integer(KeyEvent.VK_K), new JFCKeyStroke('k', 75, 0, true)},
            {new Integer(KeyEvent.VK_L), new JFCKeyStroke('l', 76, 0, true)},
            {new Integer(KeyEvent.VK_M), new JFCKeyStroke('m', 77, 0, true)},
            {new Integer(KeyEvent.VK_N), new JFCKeyStroke('n', 78, 0, true)},
            {new Integer(KeyEvent.VK_O), new JFCKeyStroke('o', 79, 0, true)},
            {new Integer(KeyEvent.VK_P), new JFCKeyStroke('p', 80, 0, true)},
            {new Integer(KeyEvent.VK_Q), new JFCKeyStroke('q', 81, 0, true)},
            {new Integer(KeyEvent.VK_R), new JFCKeyStroke('r', 82, 0, true)},
            {new Integer(KeyEvent.VK_S), new JFCKeyStroke('s', 83, 0, true)},
            {new Integer(KeyEvent.VK_T), new JFCKeyStroke('t', 84, 0, true)},
            {new Integer(KeyEvent.VK_U), new JFCKeyStroke('u', 85, 0, true)},
            {new Integer(KeyEvent.VK_V), new JFCKeyStroke('v', 86, 0, true)},
            {new Integer(KeyEvent.VK_W), new JFCKeyStroke('w', 87, 0, true)},
            {new Integer(KeyEvent.VK_X), new JFCKeyStroke('x', 88, 0, true)},
            {new Integer(KeyEvent.VK_Y), new JFCKeyStroke('y', 89, 0, true)},
            {new Integer(KeyEvent.VK_Z), new JFCKeyStroke('z', 90, 0, true)},

            {
                new Integer(KeyEvent.VK_ENTER),
                new JFCKeyStroke('\n', KeyEvent.VK_ENTER, 0, true)
            },
            {
                new Integer(KeyEvent.VK_BACK_SPACE),
                new JFCKeyStroke('\b', KeyEvent.VK_BACK_SPACE, 0, true)
            },
            {
                new Integer(KeyEvent.VK_TAB),
                new JFCKeyStroke('\t', KeyEvent.VK_TAB, 0, true)
            },

            {
                new Integer(KeyEvent.VK_SHIFT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_SHIFT, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_CONTROL),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_CONTROL,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_ALT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_ALT, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_PAUSE),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_PAUSE, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_CAPS_LOCK),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED,
                    KeyEvent.VK_CAPS_LOCK, 0, false)
            },
            {
                new Integer(KeyEvent.VK_ESCAPE),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_ESCAPE,
                    0, false)
            },

            {
                new Integer(KeyEvent.VK_SPACE),
                new JFCKeyStroke(' ', KeyEvent.VK_SPACE, 0, true)
            },

            {
                new Integer(KeyEvent.VK_PAGE_UP),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_PAGE_UP,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_PAGE_DOWN),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED,
                    KeyEvent.VK_PAGE_DOWN, 0, false)
            },
            {
                new Integer(KeyEvent.VK_END),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_END, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_HOME),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_HOME, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_LEFT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_LEFT, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_UP),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_UP, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_RIGHT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_RIGHT, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_DOWN),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_DOWN, 0,
                    false)
            },

            {
                new Integer(KeyEvent.VK_COMMA),
                new JFCKeyStroke(',', KeyEvent.VK_COMMA, 0, true)
            },
            {
                new Integer(KeyEvent.VK_MINUS),
                new JFCKeyStroke('-', KeyEvent.VK_MINUS, 0, true)
            },
            {
                new Integer(KeyEvent.VK_PERIOD),
                new JFCKeyStroke('.', KeyEvent.VK_PERIOD, 0, true)
            },
            {
                new Integer(KeyEvent.VK_SLASH),
                new JFCKeyStroke('/', KeyEvent.VK_SLASH, 0, true)
            },

            {new Integer(KeyEvent.VK_0), new JFCKeyStroke('0', KeyEvent.VK_0,
                    0, true)},
            {
                new Integer(KeyEvent.VK_1),
                new JFCKeyStroke('1', KeyEvent.VK_1, 0, true)
            },
            {
                new Integer(KeyEvent.VK_2),
                new JFCKeyStroke('2', KeyEvent.VK_2, 0, true)
            },
            {
                new Integer(KeyEvent.VK_3),
                new JFCKeyStroke('3', KeyEvent.VK_3, 0, true)
            },
            {
                new Integer(KeyEvent.VK_4),
                new JFCKeyStroke('4', KeyEvent.VK_4, 0, true)
            },
            {
                new Integer(KeyEvent.VK_5),
                new JFCKeyStroke('5', KeyEvent.VK_5, 0, true)
            },
            {
                new Integer(KeyEvent.VK_6),
                new JFCKeyStroke('6', KeyEvent.VK_6, 0, true)
            },
            {
                new Integer(KeyEvent.VK_7),
                new JFCKeyStroke('7', KeyEvent.VK_7, 0, true)
            },
            {
                new Integer(KeyEvent.VK_8),
                new JFCKeyStroke('8', KeyEvent.VK_8, 0, true)
            },
            {
                new Integer(KeyEvent.VK_9),
                new JFCKeyStroke('9', KeyEvent.VK_9, 0, true)
            },

            {
                new Integer(KeyEvent.VK_SEMICOLON),
                new JFCKeyStroke(';', KeyEvent.VK_SEMICOLON, 0, true)
            },
            {
                new Integer(KeyEvent.VK_EQUALS),
                new JFCKeyStroke('=', KeyEvent.VK_EQUALS, 0, true)
            },

            {
                new Integer(KeyEvent.VK_OPEN_BRACKET),
                new JFCKeyStroke('[', KeyEvent.VK_OPEN_BRACKET, 0, true)
            },
            {
                new Integer(KeyEvent.VK_BACK_SLASH),
                new JFCKeyStroke('\\', KeyEvent.VK_BACK_SLASH, 0, true)
            },
            {
                new Integer(KeyEvent.VK_CLOSE_BRACKET),
                new JFCKeyStroke(']', KeyEvent.VK_CLOSE_BRACKET, 0, true)
            },

            {new Integer(KeyEvent.VK_NUMPAD0), new JFCKeyStroke('0',
                    KeyEvent.VK_0, 0, true)},
            {
                new Integer(KeyEvent.VK_NUMPAD1),
                new JFCKeyStroke('1', KeyEvent.VK_1, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD2),
                new JFCKeyStroke('2', KeyEvent.VK_2, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD3),
                new JFCKeyStroke('3', KeyEvent.VK_3, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD4),
                new JFCKeyStroke('4', KeyEvent.VK_4, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD5),
                new JFCKeyStroke('5', KeyEvent.VK_5, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD6),
                new JFCKeyStroke('6', KeyEvent.VK_6, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD7),
                new JFCKeyStroke('7', KeyEvent.VK_7, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD8),
                new JFCKeyStroke('8', KeyEvent.VK_8, 0, true)
            },
            {
                new Integer(KeyEvent.VK_NUMPAD9),
                new JFCKeyStroke('9', KeyEvent.VK_9, 0, true)
            },
            {
                new Integer(KeyEvent.VK_MULTIPLY),
                new JFCKeyStroke('*', KeyEvent.VK_MULTIPLY, 0, true)
            },
            {
                new Integer(KeyEvent.VK_ADD),
                new JFCKeyStroke('+', KeyEvent.VK_ADD, 0, true)
            },
            {
                new Integer(KeyEvent.VK_SEPARATER),
                new JFCKeyStroke('|', KeyEvent.VK_SLASH, SHIFT, true)
            },
            {
                new Integer(KeyEvent.VK_SUBTRACT),
                new JFCKeyStroke('-', KeyEvent.VK_SUBTRACT, 0, true)
            },
            {
                new Integer(KeyEvent.VK_DECIMAL),
                new JFCKeyStroke('.', KeyEvent.VK_DECIMAL, 0, true)
            },
            {
                new Integer(KeyEvent.VK_DIVIDE),
                new JFCKeyStroke('/', KeyEvent.VK_DIVIDE, 0, true)
            },
            {
                new Integer(KeyEvent.VK_DELETE),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_DELETE,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_NUM_LOCK),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_NUM_LOCK,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_SCROLL_LOCK),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED,
                    KeyEvent.VK_SCROLL_LOCK, 0, false)
            },
            {
                new Integer(KeyEvent.VK_F1),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F1, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F2),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F2, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F3),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F3, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F4),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F4, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F5),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F5, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F6),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F6, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F7),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F7, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F8),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F8, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F9),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F9, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F10),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F10, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F11),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F11, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_F12),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_F12, 0,
                    false)
            },

            {
                new Integer(KeyEvent.VK_PRINTSCREEN),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED,
                    KeyEvent.VK_PRINTSCREEN, 0, false)
            },
            {
                new Integer(KeyEvent.VK_INSERT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_INSERT,
                    0, false)
            },

            {
                new Integer(KeyEvent.VK_BACK_QUOTE),
                new JFCKeyStroke('`', KeyEvent.VK_BACK_QUOTE, 0, true)
            },
            {
                new Integer(KeyEvent.VK_QUOTE),
                new JFCKeyStroke('\'', KeyEvent.VK_QUOTE, 0, true)
            },
            {
                new Integer(KeyEvent.VK_KP_UP),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_KP_UP, 0,
                    false)
            },
            {
                new Integer(KeyEvent.VK_KP_DOWN),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_KP_DOWN,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_KP_LEFT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_KP_LEFT,
                    0, false)
            },
            {
                new Integer(KeyEvent.VK_KP_RIGHT),
                new JFCKeyStroke(KeyEvent.CHAR_UNDEFINED, KeyEvent.VK_KP_RIGHT,
                    0, false)
            }
        };

    /**
     * Constructor.
     */
    public DefaultKeyMapping() {
        super(CHARMAP);
    }
}
