package junit.extensions.xml;

import junit.framework.Test;


/**
 * Test Case for running XML Script based testing.
 *
 * @author Kevin Wilson
 */
public interface IXMLTestSuite extends IXMLTest {
    /**
     * Returns the filename.
     *
     * @return String   The name of the test xml script file
     */
    String getFileName();

    /**
     * Add the given XML file to the TestSuite.
     *
     * @param  xmlFileName    The name of the test script file to be added.
     */
    void addFile(String xmlFileName);

    /**
     * Add the test to this suite.
     * @param test test to be added.
     */
    void addTest(Test test);
}
