package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;assertnotsame&gt; nodes.
 * Insures that the actual and expected objects are not the same.
 *
 * <H3>Summary</H3>
 * &lt;assertnotsame [message="message text"]  actualrefid="id"|actualobject="value"
 *  expectedrefid="id expectedobject="value"&gt;
 *
 * <H3>One of the following attributes is required:</H3>
 *   actualrefid  id of the object to be compared.<br>
 *   actualobject value of the object to be compared.
 *
 * <H3>One of the following attributes is required:</H3>
 *   expectedrefid  id of the object to be compared.<br>
 *   expectedobject value of the object to be compared.
 *
 * <H3>Optional Attributes:</H3>
 *   message       Optional message text to be specified.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AssertNotSameTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertEqualsTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AssertNotSameTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Obtain the expected and actual values. Then assert
     * that they are not the same.
     *
     * @throws XMLException when asserting.
     */
    public void processElement() throws XMLException {
        validateElement();
        Assert.assertNotSame(
            getMessage(),
            getExpectedObject(),
            getActualObject());
    }

    /**
     * Insure that a actual and expected attributes are
     * specified.
     *
     * @throws XMLException if one of the required
     * attributes are missing.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: at least one of expected or expectedrefid
        checkExpected();
        checkActual();
    }
}
