package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;

import java.lang.reflect.Method;


/**
 * Provide a mechanism for sending debug messages to the
 * test case developer.
 * <H3>Tag Name:</H3>
 * evaluate
 * <H3>Attributes:</H3>
 * id - Id of the result object.
 * refid - Id of the object to invoke the method.
 * method - Null parameter method. Ex JComboBox.getSelectedObject();
 * <H3>Examples:</H3>
 * &lt;evaluate id="Text" refid="JTextField1" method="getTest"/&gt;
 * @author Kevin Wilson
 */
public class EvaluateTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testcase parent test case.
     */
    public EvaluateTagHandler(final Element element, final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Handle the XML processing of the tag 'echo'.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        String id     = getString(ID);
        String refid  = getString(REFID);
        String method = getString(METHOD);

        Object obj = getXMLTestCase().getProperty(refid);
        Assert.assertNotNull("Refid not found:" + refid, obj);

        try {
            Class  clz = obj.getClass();
            Method m = clz.getMethod(
                    method,
                    new Class[0]);
            Object result = m.invoke(
                    obj,
                    new Object[0]);
            getXMLTestCase().addProperty(id, result);
        } catch (XMLException xe) {
            throw xe;
        } catch (Exception ex) {
            throw new XMLException("Could not execute method:" + method, ex,
                getElement(),
                getXMLTestCase().getPropertyCache());
        }
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // check the element tag name
        checkElementTagName(EVALUATE);

        // message is a required attribute
        checkRequiredAttribute(ID);
        checkRequiredAttribute(REFID);
        checkRequiredAttribute(METHOD);
    }
}
