/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLProcedure;

import org.w3c.dom.Element;


/**
 * Provide a mechanism for executing repetative tasks with
 * different context.
 *
 * <H3>Tag Name</H3>
 * procedure
 * <H3>Attributes</H3>
 * <pre>
 * name - the name of the procedure to be added     [required]
 * call - the name of the procedure to be called
 * </pre>
 * All other attributes will be passed as properties to the
 * procedure.
 *
 * <H3>Examples</H3>
 * <pre>
 * &lt;procedure name="login" /&gt;
 *    &lt;key string="${username}"/&gt;
 *    &lt;key string="${password}"/&gt;
 * &lt;/procedure&gt;
 *
 * &lt;procedure call="login" username="me" password="letmein" /&gt; * @author JFCUnit contributor
 * </pre>
 */
public class ProcedureTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testCase parent test case.
     */
    public ProcedureTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testSuite parent test suite
     */
    public ProcedureTagHandler(final Element element,
        final IXMLTestSuite testSuite) {
        super(element, testSuite);
    }

    /**
     * Handle the XML processing of the tag 'procedure'.
     * @throws XMLException upon failure of processing.
     */
    public void processElement() throws XMLException {
        validateElement();

        String name = getString(CALL);

        if (name != null) {
            getXMLTestCase().callProcedure(
                name,
                getElement());

            return;
        }

        name = getString(NAME);
        getTest().addProcedure(new XMLProcedure(getElement()));
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // check the element tag name
        if (this.getXMLTestCase() != null) {
            checkOneRequiredAttribute(new String[] {CALL, NAME});
        } else {
            this.checkRequiredAttribute(NAME);
        }
    }
}
