/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;

import org.w3c.dom.Element;


/**
 * Provide a mechanism for sending debug messages to the
 * test case developer.
 *
 * <H3>Tag Name</H3>
 * taghandlers
 * <H3>Attributes</H3>
 * <pre>
 * action  - add or remove
 * tagname - tag name to be processed by the handler.
 * classname - Classname of the taghandler.
 * </pre>
 * <H3>Examples</H3>
 * <pre>
 * &lt;taghandlers action="add" tagname="mytag" classname="jfcTags.MyTagHandler"/&gt;
 * </pre>
 *
 * @author Kevin Wilson
 */
public class TagHandlersTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testcase parent test case.
     */
    public TagHandlersTagHandler(final Element element,
        final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testsuite parent test suite.
     */
    public TagHandlersTagHandler(final Element element,
        final IXMLTestSuite testsuite) {
        super(element, testsuite);
    }

    /**
     * Handle the XML processing of the tag 'taghandlers'.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // message is a required attribute
        checkRequiredAttribute(ACTION);
        checkRequiredAttribute(TAGNAME);

        String action  = getString(ACTION);
        String tagname = getString(TAGNAME);

        if (ADD.equals(action)) {
            checkRequiredAttribute(CLASSNAME);

            String classname = getString(CLASSNAME);

            try {
                Class clz = Class.forName(classname);
            } catch (ClassNotFoundException ex) {
                throw new XMLException("Class not found:" + classname, ex,
                    getElement(), null);
            }

            XMLTagResourceBundle.addTagHandler(tagname, classname);
        } else if (REMOVE.equals(action)) {
            XMLTagResourceBundle.removeTagHandler(tagname);
        } else {
            throw new XMLException("Invalid action:" + action, null,
                getElement(), null);
        }
    }
}
