package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;

import org.w3c.dom.Element;


/**
 * <H3>Title:</H3>
 * WhileTagHandler
 * <H3>Description:</H3>
 * <p>The WhileTagHandler allows for some
 * flow control in a test case. The handler is pattered
 * after the xsl:choose elements.</p>
 *
 *
 * <H3>Example:</H3>
 * <pre>
 * &lt;while test=&quot;assertnotnull&quot; actualrefid=&quot;ComponentA&quot; &gt;
 *     ...do while...
 * &lt;/while&gt;
 * </pre>
 *
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: JFCUnit Sourceforge project</p>
 */
public class WhileTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed
     * @param testCase Test case processing tag handler.
     */
    public WhileTagHandler(final Element element, final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * process the element.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        boolean finished = false;

        while (!finished) {
            Element e = getElement();

            try {
                XMLTagResourceBundle.getTagHandler(
                    e,
                    getXMLTestCase(),
                    getString(e, TEST)).processElement();
            } catch (XMLException xe) {
                throw xe;
            } catch (Throwable t) {
                finished = true;
            }

            if (!finished) {
                getXMLTestCase().processChildren(e);
            }
        }
    }

    /**
     * Validate that the element is correct.
     * @throws XMLException if the tag name is not while.
     */
    public void validateElement() throws XMLException {
        super.checkElementTagName(WHILE);
    }
}
