/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client.domain;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.influxdb.client.domain.TemplateSummaryDiff;
import com.influxdb.client.domain.TemplateSummaryErrors;
import com.influxdb.client.domain.TemplateSummarySummary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * TemplateSummary
 */

public class TemplateSummary {
  public static final String SERIALIZED_NAME_SOURCES = "sources";
  @SerializedName(SERIALIZED_NAME_SOURCES)
  private List<String> sources = new ArrayList<>();

  public static final String SERIALIZED_NAME_STACK_I_D = "stackID";
  @SerializedName(SERIALIZED_NAME_STACK_I_D)
  private String stackID;

  public static final String SERIALIZED_NAME_SUMMARY = "summary";
  @SerializedName(SERIALIZED_NAME_SUMMARY)
  private TemplateSummarySummary summary = null;

  public static final String SERIALIZED_NAME_DIFF = "diff";
  @SerializedName(SERIALIZED_NAME_DIFF)
  private TemplateSummaryDiff diff = null;

  public static final String SERIALIZED_NAME_ERRORS = "errors";
  @SerializedName(SERIALIZED_NAME_ERRORS)
  private List<TemplateSummaryErrors> errors = new ArrayList<>();

  public TemplateSummary sources(List<String> sources) {
    this.sources = sources;
    return this;
  }

  public TemplateSummary addSourcesItem(String sourcesItem) {
    if (this.sources == null) {
      this.sources = new ArrayList<>();
    }
    this.sources.add(sourcesItem);
    return this;
  }

   /**
   * Get sources
   * @return sources
  **/
  public List<String> getSources() {
    return sources;
  }

  public void setSources(List<String> sources) {
    this.sources = sources;
  }

  public TemplateSummary stackID(String stackID) {
    this.stackID = stackID;
    return this;
  }

   /**
   * Get stackID
   * @return stackID
  **/
  public String getStackID() {
    return stackID;
  }

  public void setStackID(String stackID) {
    this.stackID = stackID;
  }

  public TemplateSummary summary(TemplateSummarySummary summary) {
    this.summary = summary;
    return this;
  }

   /**
   * Get summary
   * @return summary
  **/
  public TemplateSummarySummary getSummary() {
    return summary;
  }

  public void setSummary(TemplateSummarySummary summary) {
    this.summary = summary;
  }

  public TemplateSummary diff(TemplateSummaryDiff diff) {
    this.diff = diff;
    return this;
  }

   /**
   * Get diff
   * @return diff
  **/
  public TemplateSummaryDiff getDiff() {
    return diff;
  }

  public void setDiff(TemplateSummaryDiff diff) {
    this.diff = diff;
  }

  public TemplateSummary errors(List<TemplateSummaryErrors> errors) {
    this.errors = errors;
    return this;
  }

  public TemplateSummary addErrorsItem(TemplateSummaryErrors errorsItem) {
    if (this.errors == null) {
      this.errors = new ArrayList<>();
    }
    this.errors.add(errorsItem);
    return this;
  }

   /**
   * Get errors
   * @return errors
  **/
  public List<TemplateSummaryErrors> getErrors() {
    return errors;
  }

  public void setErrors(List<TemplateSummaryErrors> errors) {
    this.errors = errors;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TemplateSummary templateSummary = (TemplateSummary) o;
    return Objects.equals(this.sources, templateSummary.sources) &&
        Objects.equals(this.stackID, templateSummary.stackID) &&
        Objects.equals(this.summary, templateSummary.summary) &&
        Objects.equals(this.diff, templateSummary.diff) &&
        Objects.equals(this.errors, templateSummary.errors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sources, stackID, summary, diff, errors);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TemplateSummary {\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    stackID: ").append(toIndentedString(stackID)).append("\n");
    sb.append("    summary: ").append(toIndentedString(summary)).append("\n");
    sb.append("    diff: ").append(toIndentedString(diff)).append("\n");
    sb.append("    errors: ").append(toIndentedString(errors)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

