/*********************************************************************
*
*      Copyright (C) 2002 Andrew Khan
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
***************************************************************************/
package jxl.biff.formula;
/**
 * This file is generated by JLex.  Do not alter the contents of this file
 * because changes will be overridden
 */
import jxl.biff.WorkbookMethods;


class Yylex {
	private final int YY_BUFFER_SIZE = 512;
	private final int YY_F = -1;
	private final int YY_NO_STATE = -1;
	private final int YY_NOT_ACCEPT = 0;
	private final int YY_START = 1;
	private final int YY_END = 2;
	private final int YY_NO_ANCHOR = 4;
	private final int YY_BOL = 65536;
	private final int YY_EOF = 65537;

  int getPos() { return yychar ; }

  private boolean emptyString;

  private ExternalSheet externalSheet;
  private WorkbookMethods nameTable;
  void setExternalSheet(ExternalSheet es)
  {
    externalSheet = es;
  }
  void setNameTable(WorkbookMethods nt)
  {
    nameTable = nt;
  }
	private java.io.BufferedReader yy_reader;
	private int yy_buffer_index;
	private int yy_buffer_read;
	private int yy_buffer_start;
	private int yy_buffer_end;
	private char yy_buffer[];
	private int yychar;
	private int yyline;
	private boolean yy_at_bol;
	private int yy_lexical_state;

	Yylex (java.io.Reader reader) {
		this ();
		if (null == reader) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(reader);
	}

	Yylex (java.io.InputStream instream) {
		this ();
		if (null == instream) {
			throw (new Error("Error: Bad input stream initializer."));
		}
		yy_reader = new java.io.BufferedReader(new java.io.InputStreamReader(instream));
	}

	private Yylex () {
		yy_buffer = new char[YY_BUFFER_SIZE];
		yy_buffer_read = 0;
		yy_buffer_index = 0;
		yy_buffer_start = 0;
		yy_buffer_end = 0;
		yychar = 0;
		yyline = 0;
		yy_at_bol = true;
		yy_lexical_state = YYINITIAL;
	}

	private boolean yy_eof_done = false;
	private final int YYSTRING = 1;
	private final int YYINITIAL = 0;
	private final int yy_state_dtrans[] = {
		0,
		31
	};
	private void yybegin (int state) {
		yy_lexical_state = state;
	}
	private int yy_advance ()
		throws java.io.IOException {
		int next_read;
		int i;
		int j;

		if (yy_buffer_index < yy_buffer_read) {
			return yy_buffer[yy_buffer_index++];
		}

		if (0 != yy_buffer_start) {
			i = yy_buffer_start;
			j = 0;
			while (i < yy_buffer_read) {
				yy_buffer[j] = yy_buffer[i];
				++i;
				++j;
			}
			yy_buffer_end = yy_buffer_end - yy_buffer_start;
			yy_buffer_start = 0;
			yy_buffer_read = j;
			yy_buffer_index = j;
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}

		while (yy_buffer_index >= yy_buffer_read) {
			if (yy_buffer_index >= yy_buffer.length) {
				yy_buffer = yy_double(yy_buffer);
			}
			next_read = yy_reader.read(yy_buffer,
					yy_buffer_read,
					yy_buffer.length - yy_buffer_read);
			if (-1 == next_read) {
				return YY_EOF;
			}
			yy_buffer_read = yy_buffer_read + next_read;
		}
		return yy_buffer[yy_buffer_index++];
	}
	private void yy_move_end () {
		if (yy_buffer_end > yy_buffer_start &&
		    '\n' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
		if (yy_buffer_end > yy_buffer_start &&
		    '\r' == yy_buffer[yy_buffer_end-1])
			yy_buffer_end--;
	}
	private boolean yy_last_was_cr=false;
	private void yy_mark_start () {
		int i;
		for (i = yy_buffer_start; i < yy_buffer_index; ++i) {
			if ('\n' == yy_buffer[i] && !yy_last_was_cr) {
				++yyline;
			}
			if ('\r' == yy_buffer[i]) {
				++yyline;
				yy_last_was_cr=true;
			} else yy_last_was_cr=false;
		}
		yychar = yychar
			+ yy_buffer_index - yy_buffer_start;
		yy_buffer_start = yy_buffer_index;
	}
	private void yy_mark_end () {
		yy_buffer_end = yy_buffer_index;
	}
	private void yy_to_mark () {
		yy_buffer_index = yy_buffer_end;
		yy_at_bol = (yy_buffer_end > yy_buffer_start) &&
		            ('\r' == yy_buffer[yy_buffer_end-1] ||
		             '\n' == yy_buffer[yy_buffer_end-1] ||
		             2028/*LS*/ == yy_buffer[yy_buffer_end-1] ||
		             2029/*PS*/ == yy_buffer[yy_buffer_end-1]);
	}
	private java.lang.String yytext () {
		return (new java.lang.String(yy_buffer,
			yy_buffer_start,
			yy_buffer_end - yy_buffer_start));
	}
	private int yylength () {
		return yy_buffer_end - yy_buffer_start;
	}
	private char[] yy_double (char buf[]) {
		int i;
		char newbuf[];
		newbuf = new char[2*buf.length];
		for (i = 0; i < buf.length; ++i) {
			newbuf[i] = buf[i];
		}
		return newbuf;
	}
	private final int YY_E_INTERNAL = 0;
	private final int YY_E_MATCH = 1;
	private java.lang.String yy_error_string[] = {
		"Error: Internal error.\n",
		"Error: Unmatched input.\n"
	};
	private void yy_error (int code,boolean fatal) {
		java.lang.System.out.print(yy_error_string[code]);
		java.lang.System.out.flush();
		if (fatal) {
			throw new Error("Fatal Error.\n");
		}
	}
	private int[][] unpackFromString(int size1, int size2, String st) {
		int colonIndex = -1;
		String lengthString;
		int sequenceLength = 0;
		int sequenceInteger = 0;

		int commaIndex;
		String workString;

		int res[][] = new int[size1][size2];
		for (int i= 0; i < size1; i++) {
			for (int j= 0; j < size2; j++) {
				if (sequenceLength != 0) {
					res[i][j] = sequenceInteger;
					sequenceLength--;
					continue;
				}
				commaIndex = st.indexOf(',');
				workString = (commaIndex==-1) ? st :
					st.substring(0, commaIndex);
				st = st.substring(commaIndex+1);
				colonIndex = workString.indexOf(':');
				if (colonIndex == -1) {
					res[i][j]=Integer.parseInt(workString);
					continue;
				}
				lengthString =
					workString.substring(colonIndex+1);
				sequenceLength=Integer.parseInt(lengthString);
				workString=workString.substring(0,colonIndex);
				sequenceInteger=Integer.parseInt(workString);
				res[i][j] = sequenceInteger;
				sequenceLength--;
			}
		}
		return res;
	}
	private int yy_acpt[] = {
		/* 0 */ YY_NOT_ACCEPT,
		/* 1 */ YY_NO_ANCHOR,
		/* 2 */ YY_NO_ANCHOR,
		/* 3 */ YY_NO_ANCHOR,
		/* 4 */ YY_NO_ANCHOR,
		/* 5 */ YY_NO_ANCHOR,
		/* 6 */ YY_NO_ANCHOR,
		/* 7 */ YY_NO_ANCHOR,
		/* 8 */ YY_NO_ANCHOR,
		/* 9 */ YY_NO_ANCHOR,
		/* 10 */ YY_NO_ANCHOR,
		/* 11 */ YY_NO_ANCHOR,
		/* 12 */ YY_NO_ANCHOR,
		/* 13 */ YY_NO_ANCHOR,
		/* 14 */ YY_NO_ANCHOR,
		/* 15 */ YY_NO_ANCHOR,
		/* 16 */ YY_NO_ANCHOR,
		/* 17 */ YY_NO_ANCHOR,
		/* 18 */ YY_NO_ANCHOR,
		/* 19 */ YY_NO_ANCHOR,
		/* 20 */ YY_NO_ANCHOR,
		/* 21 */ YY_NO_ANCHOR,
		/* 22 */ YY_NO_ANCHOR,
		/* 23 */ YY_NO_ANCHOR,
		/* 24 */ YY_NO_ANCHOR,
		/* 25 */ YY_NO_ANCHOR,
		/* 26 */ YY_NO_ANCHOR,
		/* 27 */ YY_NO_ANCHOR,
		/* 28 */ YY_NO_ANCHOR,
		/* 29 */ YY_NO_ANCHOR,
		/* 30 */ YY_NO_ANCHOR,
		/* 31 */ YY_NO_ANCHOR,
		/* 32 */ YY_NO_ANCHOR,
		/* 33 */ YY_NOT_ACCEPT,
		/* 34 */ YY_NO_ANCHOR,
		/* 35 */ YY_NO_ANCHOR,
		/* 36 */ YY_NO_ANCHOR,
		/* 37 */ YY_NO_ANCHOR,
		/* 38 */ YY_NO_ANCHOR,
		/* 39 */ YY_NOT_ACCEPT,
		/* 40 */ YY_NO_ANCHOR,
		/* 41 */ YY_NOT_ACCEPT,
		/* 42 */ YY_NO_ANCHOR,
		/* 43 */ YY_NOT_ACCEPT,
		/* 44 */ YY_NO_ANCHOR,
		/* 45 */ YY_NOT_ACCEPT,
		/* 46 */ YY_NOT_ACCEPT,
		/* 47 */ YY_NOT_ACCEPT,
		/* 48 */ YY_NOT_ACCEPT,
		/* 49 */ YY_NOT_ACCEPT,
		/* 50 */ YY_NOT_ACCEPT,
		/* 51 */ YY_NOT_ACCEPT,
		/* 52 */ YY_NOT_ACCEPT,
		/* 53 */ YY_NOT_ACCEPT,
		/* 54 */ YY_NOT_ACCEPT,
		/* 55 */ YY_NOT_ACCEPT,
		/* 56 */ YY_NOT_ACCEPT,
		/* 57 */ YY_NOT_ACCEPT,
		/* 58 */ YY_NOT_ACCEPT,
		/* 59 */ YY_NOT_ACCEPT,
		/* 60 */ YY_NOT_ACCEPT,
		/* 61 */ YY_NOT_ACCEPT,
		/* 62 */ YY_NOT_ACCEPT,
		/* 63 */ YY_NOT_ACCEPT,
		/* 64 */ YY_NOT_ACCEPT,
		/* 65 */ YY_NOT_ACCEPT,
		/* 66 */ YY_NOT_ACCEPT,
		/* 67 */ YY_NOT_ACCEPT,
		/* 68 */ YY_NO_ANCHOR,
		/* 69 */ YY_NOT_ACCEPT,
		/* 70 */ YY_NO_ANCHOR,
		/* 71 */ YY_NOT_ACCEPT,
		/* 72 */ YY_NOT_ACCEPT,
		/* 73 */ YY_NOT_ACCEPT,
		/* 74 */ YY_NOT_ACCEPT,
		/* 75 */ YY_NOT_ACCEPT,
		/* 76 */ YY_NO_ANCHOR,
		/* 77 */ YY_NOT_ACCEPT
	};
	private int yy_cmap[] = unpackFromString(1,65538,
"14:8,25:3,14:21,25,15,28,14,11,14:2,13,26,27,3,1,8,2,10,4,9:10,16,14,7,6,5," +
"14:2,22,12:3,20,21,12:5,23,12:5,18,24,17,19,12:5,14:6,12:26,14:65413,0:2")[0];

	private int yy_rmap[] = unpackFromString(1,78,
"0,1:5,2,1,3,1,4,1:8,5,6,1,7,8,9,10,11,12,10,13,14,15,1,16,17,10,1:2,18,19,2" +
"0,21,22,7,23,24,25,26,27,28,29,30,31,32,33,34,9,35,36,11,37,38,39,40,41,42," +
"43,14,44,45,46,47,48,49,50,51,52,53")[0];

	private int yy_nxt[][] = unpackFromString(54,29,
"1,2,3,4,5,6,7,8,9,10,33,39,33,41,-1:2,11,69,33:3,77,33:3,12,13,14,15,-1:35," +
"16,-1:27,17,18,-1:31,10,43,-1:27,19,-1:6,72,-1:21,34,35,45,35,-1:2,46,47,35" +
":8,-1,21,-1:11,22,-1:29,36,-1,36,-1:4,36:8,-1:13,24,-1:28,42,35,-1,35,-1:2," +
"46,-1,35:8,-1,21,-1:11,26,-1:28,27,-1:6,63,-1:22,37,-1,37,-1:4,37:8,-1:13,3" +
"0,-1:19,1,38:27,32,-1:9,19,20,45,20,-1:2,46,47,20:8,-1,21,-1:11,34,42,-1,42" +
",-1:3,72,42:8,-1:5,38:27,-1:11,48,-1,48,-1:4,48:8,-1:13,42,35,-1,35,-1:2,46" +
",-1,35:3,25,35:4,-1,21,-1:3,41:12,49,41:15,-1:9,42:2,-1,42,-1:4,42:8,-1:13," +
"42,35,-1,35,-1:2,46,-1,35:3,28,35:4,-1,21,-1:11,19,-1:29,50,71,50,-1:4,50:8" +
",-1:14,23,51,23,-1:4,23:8,-1:13,19,52,45,52,-1:3,47,52:8,-1:19,53,-1:22,24," +
"55,56,55,-1:4,55:8,-1:14,23,-1,23,-1:4,23:8,-1:13,19,-1,45,-1:4,47,-1:22,57" +
",74,57,-1:4,57:8,-1:13,26,58,59,58,-1:4,58:8,-1:13,24,-1,56,-1:26,27,60,61," +
"60,-1:3,62,60:8,-1:13,26,-1,59,-1:26,27,-1,61,-1:4,62,-1:21,27,-1:29,29,64," +
"29,-1:4,29:8,-1:14,65,75,65,-1:4,65:8,-1:14,29,-1,29,-1:4,29:8,-1:13,30,66," +
"67,66,-1:4,66:8,-1:13,30,-1,67,-1:26,34,35,45,35,-1:2,46,47,35:2,40,35:5,-1" +
",21,-1:11,19,20,45,20,-1:2,46,47,20,68,20:6,-1,21,-1:11,42,35,-1,35,-1:2,46" +
",-1,35:7,44,-1,21,-1:12,50,-1,50,-1:4,50:8,-1:14,54,73,54,-1:4,54:8,-1:14,5" +
"4,-1,54,-1:4,54:8,-1:14,57,-1,57,-1:4,57:8,-1:14,65,-1,65,-1:4,65:8,-1:13,3" +
"4,35,45,35,-1:2,46,47,35:6,70,35,-1,21,-1:11,19,20,45,20,-1:2,46,47,20:5,76" +
",20:2,-1,21,-1:2");

	public ParseItem yylex ()
		throws java.io.IOException, 
 jxl.biff.formula.FormulaException

		{
		int yy_lookahead;
		int yy_anchor = YY_NO_ANCHOR;
		int yy_state = yy_state_dtrans[yy_lexical_state];
		int yy_next_state = YY_NO_STATE;
		int yy_last_accept_state = YY_NO_STATE;
		boolean yy_initial = true;
		int yy_this_accept;

		yy_mark_start();
		yy_this_accept = yy_acpt[yy_state];
		if (YY_NOT_ACCEPT != yy_this_accept) {
			yy_last_accept_state = yy_state;
			yy_mark_end();
		}
		while (true) {
			if (yy_initial && yy_at_bol) yy_lookahead = YY_BOL;
			else yy_lookahead = yy_advance();
			yy_next_state = YY_F;
			yy_next_state = yy_nxt[yy_rmap[yy_state]][yy_cmap[yy_lookahead]];
			if (YY_EOF == yy_lookahead && true == yy_initial) {
				return null;
			}
			if (YY_F != yy_next_state) {
				yy_state = yy_next_state;
				yy_initial = false;
				yy_this_accept = yy_acpt[yy_state];
				if (YY_NOT_ACCEPT != yy_this_accept) {
					yy_last_accept_state = yy_state;
					yy_mark_end();
				}
			}
			else {
				if (YY_NO_STATE == yy_last_accept_state) {
					throw (new Error("Lexical Error: Unmatched Input."));
				}
				else {
					yy_anchor = yy_acpt[yy_last_accept_state];
					if (0 != (YY_END & yy_anchor)) {
						yy_move_end();
					}
					yy_to_mark();
					switch (yy_last_accept_state) {
					case 1:
						
					case -2:
						break;
					case 2:
						{ return new Plus() ;}
					case -3:
						break;
					case 3:
						{ return new Minus() ; }
					case -4:
						break;
					case 4:
						{ return new Multiply() ; }
					case -5:
						break;
					case 5:
						{ return new Divide() ; }
					case -6:
						break;
					case 6:
						{ return new GreaterThan() ; }
					case -7:
						break;
					case 7:
						{ return new Equal() ; }
					case -8:
						break;
					case 8:
						{ return new LessThan() ; }
					case -9:
						break;
					case 9:
						{ return new ArgumentSeparator() ; }
					case -10:
						break;
					case 10:
						{ return new IntegerValue(yytext()) ; }
					case -11:
						break;
					case 11:
						{ return new RangeSeparator(); }
					case -12:
						break;
					case 12:
						{}
					case -13:
						break;
					case 13:
						{ return new OpenParentheses() ;}
					case -14:
						break;
					case 14:
						{ return new CloseParentheses() ;}
					case -15:
						break;
					case 15:
						{emptyString = true; yybegin(YYSTRING);}
					case -16:
						break;
					case 16:
						{ return new GreaterEqual() ; }
					case -17:
						break;
					case 17:
						{ return new NotEqual() ; }
					case -18:
						break;
					case 18:
						{ return new LessEqual() ; }
					case -19:
						break;
					case 19:
						{ return new CellReference(yytext()) ; }
					case -20:
						break;
					case 20:
						{return new NameRange(yytext(), nameTable); }
					case -21:
						break;
					case 21:
						{ return new StringFunction(yytext()) ; }
					case -22:
						break;
					case 22:
						{ return new DoubleValue(yytext()) ; }
					case -23:
						break;
					case 23:
						{ return new ColumnRange(yytext()); }
					case -24:
						break;
					case 24:
						{return new CellReference3d(yytext(),externalSheet) ; }
					case -25:
						break;
					case 25:
						{return new BooleanValue(yytext());}
					case -26:
						break;
					case 26:
						{ return new Area(yytext()) ; }
					case -27:
						break;
					case 27:
						{return new CellReference3d(yytext(),externalSheet) ; }
					case -28:
						break;
					case 28:
						{return new BooleanValue(yytext());}
					case -29:
						break;
					case 29:
						{ return new ColumnRange3d(yytext(),externalSheet) ; }
					case -30:
						break;
					case 30:
						{ return new Area3d(yytext(),externalSheet) ; }
					case -31:
						break;
					case 31:
						{emptyString = false; return new StringValue(yytext()) ; }
					case -32:
						break;
					case 32:
						{yybegin(YYINITIAL); if (emptyString) return new StringValue("");}
					case -33:
						break;
					case 34:
						{ return new CellReference(yytext()) ; }
					case -34:
						break;
					case 35:
						{return new NameRange(yytext(), nameTable); }
					case -35:
						break;
					case 36:
						{ return new ColumnRange(yytext()); }
					case -36:
						break;
					case 37:
						{ return new ColumnRange3d(yytext(),externalSheet) ; }
					case -37:
						break;
					case 38:
						{emptyString = false; return new StringValue(yytext()) ; }
					case -38:
						break;
					case 40:
						{return new NameRange(yytext(), nameTable); }
					case -39:
						break;
					case 42:
						{return new NameRange(yytext(), nameTable); }
					case -40:
						break;
					case 44:
						{return new NameRange(yytext(), nameTable); }
					case -41:
						break;
					case 68:
						{return new NameRange(yytext(), nameTable); }
					case -42:
						break;
					case 70:
						{return new NameRange(yytext(), nameTable); }
					case -43:
						break;
					case 76:
						{return new NameRange(yytext(), nameTable); }
					case -44:
						break;
					default:
						yy_error(YY_E_INTERNAL,false);
					case -1:
					}
					yy_initial = true;
					yy_state = yy_state_dtrans[yy_lexical_state];
					yy_next_state = YY_NO_STATE;
					yy_last_accept_state = YY_NO_STATE;
					yy_mark_start();
					yy_this_accept = yy_acpt[yy_state];
					if (YY_NOT_ACCEPT != yy_this_accept) {
						yy_last_accept_state = yy_state;
						yy_mark_end();
					}
				}
			}
		}
	}
}
