package junit.extensions.jfcunit.finder;

import junit.extensions.jfcunit.xml.JFCXMLConstants;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.elements.AbstractTagHandler;

import org.w3c.dom.Element;


/**
 * This element helps locate objects within the gui. It
 * uses the underlying JFCUnit finders to locate objects.
 * The finders implementation may be extended via the
 * TagMapping.properties file specified in the classpath.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a DialogFinder and executes the find.
 * </p>
 *
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">This element specifies the finder implementation to use.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">AbstractButtonFinder ComponentFinder DialogFinder FrameFinder
 *     JLabelFinder JMenuItemFinder JWindowFinder NamedComponentFinder or other custom
 *     finder tags specified in TagMapping.properties.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">others</td>
 *     <td valign="top">See corresponding tag handler implementation
 *     for a definition of other attributes that may be required.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;DialogFinder&quot;
 *    id=&quot;MyDialog&quot;
 *    title=&quot;^My dialog box$&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above uses the TagHandler associated with the DialogFinder tag in the
 * TagMapping.properties file. In the default jfcUnit case this would be the
 * junit.extensions.jfcunit.finder.DialogFinderTagMapping.
 * </p>
 *
 * @see junit.extensions.jfcunit.finder.AbstractButtonFinderTagHandler
 * @see junit.extensions.jfcunit.finder.ComponentFinderTagHandler
 * @see junit.extensions.jfcunit.finder.DialogFinderTagHandler
 * @see junit.extensions.jfcunit.finder.FrameFinderTagHandler
 * @see junit.extensions.jfcunit.finder.JLabelFinderTagHandler
 * @see junit.extensions.jfcunit.finder.JMenuItemFinderTagHandler
 * @see junit.extensions.jfcunit.finder.JWindowFinderTagHandler
 * @see junit.extensions.jfcunit.finder.NamedComponentFinderTagHandler
 * @see junit.extensions.jfcunit.finder.JPopupMenuFinderTagHandler
 * @see junit.extensions.jfcunit.finder.LabeledComponentFinderTagHander
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class FindTagHandler extends AbstractTagHandler
    implements JFCXMLConstants {
    /**
     * Constructor for FindTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public FindTagHandler(final Element element, final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Returns the value of the FINDER attribute for this element.
     * @return String  The value of the FINDER attribute.
     */
    public String getFinder() {
        return getString(FINDER);
    }

    /**
     * Returns the value of the NAME attribute for this element.
     * @return String  The value of the NAME attribute.
     */
    public String getName() {
        return getString(NAME);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     */
    public void processElement() throws XMLException {
        validateElement();

        XMLTagResourceBundle.getTagHandler(
            getElement(),
            getXMLTestCase(),
            getFinder()).processElement();
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // check the element tag name
        checkElementTagName(FIND);

        // required attribute: class
        checkRequiredAttribute(FINDER);
    }
}
