package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;

import javax.swing.Icon;


/**
 * This is a extension of the findTagHandler element. Where the
 * finder specified is JMenuItemFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a JMenuItemFinder and executes the find.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * JMenuItemFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to JMenuItemFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Search in all windows</td>
 *     <td valign="top">Panel to be searched</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">The index of the element to select from the combo box.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">Zero based index of list items.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">label</td>
 *     <td valign="top">The text of the label to be found.</td>
 *     <td valign="top" align="center">label or iconfile is required</td>
 *     <td valign="top">None</td>
 *     <td valign="top">Regular expression defining the label.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">iconfile</td>
 *     <td valign="top">The iconfile which is used as a icon on the button.</td>
 *     <td valign="top" align="center">label or iconfile is required.</td>
 *     <td valign="top">None</td>
 *     <td valign="top">Icon file name to be loaded and compared.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">caseindependent</td>
 *     <td valign="top">Ignore the case if true</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true/false</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;JMenuItemFinder&quot;
 *    id=&quot;MenuItem&quot;
 *    label=&quot;^My menu$&quot;
 *    index=&quot;0&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the menu item with
 * a complete title &quot;My menu&quot;
 * </p>
 * @see junit.extensions.jfcunit.finder.JMenuItemFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class JMenuItemFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for JMenuItemFinderTagHandler.
     *
     * @param element     The element to be processed.
     * @param testCase    The IXMLTestCase that uses this element.
     */
    public JMenuItemFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement().
     */
    public void processElement() throws XMLException {
        validateElement();

        String  label           = getLabel();
        Icon    icon            = getIcon();
        boolean caseIndependent = getCaseIndependent();

        find(new JMenuItemFinder(label, icon, caseIndependent));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: at least one of label or icon file
        checkAtLeastOneRequiredAttribute(
            getElement(),
            new String[] {LABEL, ICONFILE});
    }
}
