package junit.extensions.xml;

import org.w3c.dom.Element;


/**
 * Test Case Interface for running XML Script based testing.
 *
 * @author Kevin Wilson
 */
public interface IXMLTestCase extends IXMLTest {
    /**
     * Set the name for the test case.
     * @param name Name of the test case.
     */
    void setName(String name);

    /**
     * Get the name for the test case.
     * @return name of the test case.
     */
    String getName();

    /**
     * Call the procedure of (name) passing the attributes
     * associated with the elements.
     * @param name name of the procedure.
     * @param callElement Source element of the call.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    void callProcedure(String name, Element callElement) throws XMLException;

    /**
     * Process each child element.
     * @param element Element which has children.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    void processChildren(Element element) throws XMLException;
}
