/*
 * Created on Oct 27, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

import org.w3c.dom.Element;

import javax.swing.text.JTextComponent;


/**
 * Provide a mechanism for validating the contents of a text field.
 *
 * <H3>Tag Name:</H3>
 * AssertTextFieldContains
 * <H3>Attributes:</H3>
 * <pre>
 * id      - the text field to validate           [required]
 * value   - the expected value in the text field [required]
 * useRE   - allow the value to contain a regular expression [optional]
 *           default - is false exact string match needed
 *           If set to true partial strings will work.
 * </pre>
 * <H3>Examples:</H3>
 * &lt;assertTextFieldContains id="component1" value="Joe"/&gt;
 * @author John Yunker
 */
public class AssertTextFieldContainsTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by this tag handler.
     * @param testcase containing test case.
     */
    public AssertTextFieldContainsTagHandler(final Element element,
        final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Handle the XML processing of the tag 'assertTextFieldContains'.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        String id = getString(ID);

        Object o = ((IXMLTestCase) getTestCase()).getProperty(id);

        if (o == null) {
            System.out.println("Error: Unable to locate object id:" + id);
        } else {
            if (o instanceof JTextComponent) {
                String         expectedval = getString(VALUE);
                JTextComponent jtf = (JTextComponent) o;

                String         msg = "Component: " + id + " Expected: "
                    + expectedval + " Retrieved: " + jtf.getText();

                boolean useRegExp = getBoolean(USERE);

                if (useRegExp) {
                    RE regexp = null;

                    try {
                        regexp = new RE(expectedval);
                    } catch (RESyntaxException ex) {
                        throw new XMLException(
                            "Could not create regular expression:"
                            + expectedval,
                            ex,
                            getElement(),
                            getXMLTestCase().getPropertyCache());
                    }

                    Assert.assertTrue(
                        msg,
                        regexp.match(jtf.getText()));
                } else {
                    if (!jtf.getText().equals(expectedval)) {
                        System.out.println("Assertion failed: " + msg);
                    }

                    Assert.assertEquals(
                        jtf.getText(),
                        expectedval);
                }
            } else {
                throw new XMLException("id does not reference a JTextComponent",
                    null,
                    getElement(),
                    getTest().getPropertyCache());
            }
        }
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException may be thrown.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // id is a required attribute
        checkRequiredAttribute(ID);

        // value is a required attribute
        checkRequiredAttribute(VALUE);
    }
}
