/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Fqn;
import org.jboss.cache.eviction.EvictionAlgorithm;
import org.jboss.cache.eviction.LRUPolicy;
import org.jboss.cache.eviction.Region;
import org.jboss.logging.Logger;

/**
 * Eviction policy based on the FIFO algorithm where users can specify the max
 * number of nodes and time-to-live for the nodes.
 * 
 * @author Morten Kvistgaard 2004-10
 */
public class FIFOPolicy extends LRUPolicy {

    public FIFOPolicy() {
        super();
        log_ = Logger.getLogger(FIFOPolicy.class);
    }
    
	protected EvictionAlgorithm getEvictionAlgorithm() {
        return new FIFOAlgorithm();
	}
    
	/* 
	 * @see org.jboss.cache..eviction.LRUPolicy#nodeModified(...)
	 */
	public void nodeModified(Fqn fqn) {
		if(log_.isTraceEnabled()) {
			log_.trace("nodeModified(): fqn- " +fqn);
		}
		Region region = regionManager_.getRegion(fqn.toString());
		// TODO May need to optimize to check if this fqn is already on the queue. No need to process it twice.
		region.setVisitedNode(fqn);
	}
    
	public void nodeVisited(Fqn fqn) {
        // visiting a node will not extend it's lifetime
        if(log_.isDebugEnabled()) {
            log_.debug("nodeVisited(): fqn- " +fqn);
        }
	}
}
