/**
 * DynamicReports - Free Java reporting library for creating reports dynamically
 *
 * Copyright (C) 2010 - 2011 Ricardo Mariaca
 * http://dynamicreports.sourceforge.net
 *
 * This file is part of DynamicReports.
 *
 * DynamicReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DynamicReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with DynamicReports. If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.dynamicreports.report.base.chart.dataset;

import java.util.ArrayList;
import java.util.List;

import net.sf.dynamicreports.report.base.DRDataset;
import net.sf.dynamicreports.report.constant.Constants;
import net.sf.dynamicreports.report.definition.chart.dataset.DRIChartDataset;
import net.sf.dynamicreports.report.definition.expression.DRIExpression;

import org.apache.commons.lang.Validate;

/**
 * @author Ricardo Mariaca (dynamicreports@gmail.com)
 */
public class DRChartDataset implements DRIChartDataset {
	private static final long serialVersionUID = Constants.SERIAL_VERSION_UID;

	private DRDataset subDataset;
	private DRIExpression<?> valueExpression;
	private List<DRChartSerie> series;

	public DRChartDataset() {
		series = new ArrayList<DRChartSerie>();
	}

	public DRDataset getSubDataset() {
		return subDataset;
	}

	public void setSubDataset(DRDataset subDataset) {
		this.subDataset = subDataset;
	}

	public DRIExpression<?> getValueExpression() {
		return valueExpression;
	}

	public void setValueExpression(DRIExpression<?> valueExpression) {
		Validate.notNull(valueExpression, "valueExpression must not be null");
		this.valueExpression = valueExpression;
	}

	public void addSerie(DRChartSerie serie) {
		Validate.notNull(serie, "serie must not be null");
		series.add(serie);
	}

	public List<DRChartSerie> getSeries() {
		return series;
	}
}
