/**
 * DynamicReports - Free Java reporting library for creating reports dynamically
 *
 * Copyright (C) 2010 - 2011 Ricardo Mariaca
 * http://dynamicreports.sourceforge.net
 *
 * This file is part of DynamicReports.
 *
 * DynamicReports is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * DynamicReports is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with DynamicReports. If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.dynamicreports.report.base.component;

import net.sf.dynamicreports.report.constant.ComponentDimensionType;
import net.sf.dynamicreports.report.constant.ComponentPositionType;
import net.sf.dynamicreports.report.constant.Constants;
import net.sf.dynamicreports.report.constant.StretchType;
import net.sf.dynamicreports.report.definition.DRIGroup;
import net.sf.dynamicreports.report.definition.component.DRIDimensionComponent;

import org.apache.commons.lang.Validate;

/**
 * @author Ricardo Mariaca (dynamicreports@gmail.com)
 */
public abstract class DRDimensionComponent extends DRComponent implements DRIDimensionComponent {
	private static final long serialVersionUID = Constants.SERIAL_VERSION_UID;

	private Integer width;
	private Integer height;
	private ComponentDimensionType widthType;
	private ComponentDimensionType heightType;
	private ComponentPositionType positionType;
	private StretchType stretchType;
	private Boolean printInFirstWholeBand;
	private Boolean printWhenDetailOverflows;
	private DRIGroup printWhenGroupChanges;

  /**
   * Returns the component width.
   *
   * @return the component width >= 0
   */
	public Integer getWidth() {
		return width;
	}

  /**
   * Sets the component width.
   * @see net.sf.dynamicreports.report.builder.Units
   *
   * @param width the component width >= 0
   * @exception IllegalArgumentException if <code>width</code> is < 0
   */
	public void setWidth(Integer width) {
		if (width != null) {
			Validate.isTrue(width >= 0, "width must be >= 0");
		}
		this.width = width;
	}

  /**
   * Returns the component height.
   *
   * @return the component height >= 0
   */
	public Integer getHeight() {
		return height;
	}

  /**
   * Sets the component height.
   * @see net.sf.dynamicreports.report.builder.Units
   *
   * @param height the component height >= 0
   * @exception IllegalArgumentException if <code>height</code> is < 0
   */
	public void setHeight(Integer height) {
		if (height != null) {
			Validate.isTrue(height >= 0, "height must be >= 0");
		}
		this.height = height;
	}

	public ComponentDimensionType getWidthType() {
		return widthType;
	}

	public void setWidthType(ComponentDimensionType widthType) {
		this.widthType = widthType;
	}

	public ComponentDimensionType getHeightType() {
		return heightType;
	}

	public void setHeightType(ComponentDimensionType heightType) {
		this.heightType = heightType;
	}

	public ComponentPositionType getPositionType() {
		return positionType;
	}

	public void setPositionType(ComponentPositionType positionType) {
		this.positionType = positionType;
	}

	public StretchType getStretchType() {
		return stretchType;
	}

	public void setStretchType(StretchType stretchType) {
		this.stretchType = stretchType;
	}

	public Boolean getPrintInFirstWholeBand() {
		return printInFirstWholeBand;
	}

	public void setPrintInFirstWholeBand(Boolean printInFirstWholeBand) {
		this.printInFirstWholeBand = printInFirstWholeBand;
	}

	public Boolean getPrintWhenDetailOverflows() {
		return printWhenDetailOverflows;
	}

	public void setPrintWhenDetailOverflows(Boolean printWhenDetailOverflows) {
		this.printWhenDetailOverflows = printWhenDetailOverflows;
	}

	public DRIGroup getPrintWhenGroupChanges() {
		return printWhenGroupChanges;
	}

	public void setPrintWhenGroupChanges(DRIGroup printWhenGroupChanges) {
		this.printWhenGroupChanges = printWhenGroupChanges;
	}
}
