package junit.extensions.jfcunit.eventdata;

import java.util.EventListener;


/**
 * Listener interface to recieve {@link junit.extensions.jfcunit.eventdata.AbstractEventData} generated
 * from a record session of the {@link junit.extensions.jfcunit.eventdata.JFCEventManager}.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public interface JFCEventDataListener extends EventListener {
    /**
     * This method should be implemented by the recording class which will
     * translate the {@link AbstractEventData} into a serializable event data.
     *
     * @param evtData The AbstractEventData which is to be processed by the listener.
     */
    void handleEvent(final AbstractEventData evtData);
}
