package junit.extensions.jfcunit.eventdata;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;


/**
 * This is a extension of the click and drag elements. Where the
 * type specified is JSpinnerMouseEventData.
 *
 * <h3>Description</h3>
 * <p>
 *   Nothing is invoked directly by this tag handler. The click and drag elements
 *   use this tag handler to customize the data specificly for the type specified.
 * </p>
 *
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">type</td>
 *     <td valign="top">For this element the type must be set to JSpinnerMouseEventData</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">Id of a object reference which has been previously found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">sub</td>
 *     <td valign="top">The sub component of the spinner</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">Invalid</td>
 *     <td valign="top">editor up down</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">clicks</td>
 *     <td valign="top">The number of clicks to be executed.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">1</td>
 *     <td valign="top">Positive Integer</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">modifiers</td>
 *     <td valign="top">The modifiers to be used for this event.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Button1 if popup is false otherwise Button3</td>
 *     <td valign="top">alt altgr control meta shift button1 button2 button3</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">popup</td>
 *     <td valign="top">True if this is event is using the popup button.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">false</td>
 *     <td valign="top">true false</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">sleeptime</td>
 *     <td valign="top">Maximum sleep time</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">500</td>
 *     <td valign="top">Positive Integer representing the milli-seconds</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">position</td>
 *     <td valign="top">Positioning of the mouse within the bounds of the component.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">center</td>
 *     <td valign="top">center north northeast east southeast south southwest west northwest custom percentage</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">reference</td>
 *     <td valign="top">Reference point or number for position calculation.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">null</td>
 *     <td valign="top">integers &quot;x,y&quot;</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">Offset into the text sub component.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">-1</td>
 *     <td valign="top">integers &quot;Positive Integer representing the offset into the text.&quot;</td>
 *   </tr>
 *
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;click
 *    type=&quot;JSpinnerMouseEventData&quot;
 *    refid=&quot;Spinner&quot;
 *    sub=&quot;up&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above clicks once on the center of the up arrow of the
 * spinner component identified by Spinner.
 * </p>
 * @see junit.extensions.jfcunit.eventdata.JSpinnerMouseEventData
 * @author Kevin Wilson
 */
public class JSpinnerMouseEventDataTagHandler extends BaseEventDataTagHandler {
    /**
     * Constructor for JSpinnerMouseEventDataTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public JSpinnerMouseEventDataTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException may be thrown if element is not fully understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        setEventData(
            new JSpinnerMouseEventData(
                getJFCTestCase(),
                getComponent(),
                getSubComponent(),
                getClicks(),
                getModifiers(),
                getPopupTrigger(),
                getSleepTime(),
                getPosition(),
                getReference(),
                getOffset()));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException may be thrown.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        checkRequiredAttribute(SUBCOMPONENT);
    }

    /**
     * Returns the subcomponent that corresponds to the value of the SUBCOMPONENT attribute for this
     * element. Defaults to INVALID_SUBCOMPONENT if no corresponding component is found.
     * @return int  The value of the component that corresponds to the value of the SUBCOMPONENT
     * attribute, INVALID_SUBCOMPONENT if not found.
     */
    protected int getSubComponent() {
        String sub = getString(SUBCOMPONENT);

        if (UP.equals(sub)) {
            return UP_ARROW_SUBCOMPONENT;
        } else if (DOWN.equals(sub)) {
            return DOWN_ARROW_SUBCOMPONENT;
        } else if (EDITOR.equals(sub)) {
            return EDITOR_SUBCOMPONENT;
        }

        return INVALID_SUBCOMPONENT;
    }
}
