package junit.extensions.jfcunit.finder;

import java.awt.Component;


/**
 * A generic {@link java.awt.Component} finder which uses just the type (class) for filtering.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class ComponentFinder extends Finder {
    /**
     * The type of the {@link java.awt.Component}.
     */
    private Class m_compCls = null;

    /**
     * Constructor accepting all arguments needed to filter the {@link java.awt.Component}.
     *
     * @param cls    The desired type of the component.
     */
    public ComponentFinder(final Class cls) {
        setComponentClass(cls);
    }

    /**
     * Set the class of the object to be found.
     * @param cls Class of the objects to be found.
     */
    public final void setComponentClass(final Class cls) {
        m_compCls = cls;
    }

    /**
     * Get the class associated with the finder.
     * @return Component class to be found by the finder.
     */
    public final Class getComponentClass() {
        return m_compCls;
    }

    /**
     * Method that returns true if the given {@link java.awt.Component} matches the search
     * criteria.
     *
     * @param comp   The component to test
     * @return true if this component is a match
     */
    public boolean testComponent(final Component comp) {
        return ((comp != null) && isValidForProcessing(comp, m_compCls));
    }
}
