package junit.extensions.jfcunit.finder;

import junit.extensions.jfcunit.WindowMonitor;

import java.awt.Component;
import java.awt.Container;

import java.util.Iterator;

import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;


/**
 * <p>Title: class JInternalFrameFinder.</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: </p>
 * @author not attributable
 * @version 1.0
 */
public class JInternalFrameFinder extends ComponentFinder {
    /**
     * Title of the frame.
     */
    private String m_title = null;

    /**
     * Constructor for the internal frame finder.
     * @param title Title of the frame.
     * @param ignoreCase Ignore the case if true.
     */
    public JInternalFrameFinder(final String title, final boolean ignoreCase) {
        super(javax.swing.JDesktopPane.class);
        setTitle(title);
    }

    /**
     * Set the title to be matched.
     * @param title to be matched.
     */
    public final void setTitle(final String title) {
        m_title = title;
    }

    /**
     * Get the title to be matched.
     * @return title to be matched.
     */
    public final String getTitle() {
        return m_title;
    }

    /**
     * Find the DeskTop then search the desktops for the internal
     * frame with the given name.
     * @param cont Container to be searched.
     * @param index Index of the matching internal frames to return.
     * @return The Internal Frame which matches at the given index.
     */
    public Component find(final Container cont, final int index) {
        long date = System.currentTimeMillis() + (getWait() * 1000);

        do {
            Container[] conts;

            if (cont == null) {
                conts = WindowMonitor.getWindows();
            } else {
                conts = new Container[] {cont};
            }

            int idx = -1;

            for (int w = 0; w < conts.length; w++) {
                int      dsk  = 0;
                Iterator iter = findComponentList(this, conts[w], null, index)
                                    .iterator();

                while (iter.hasNext()) {
                    JDesktopPane     desktop = (JDesktopPane) iter.next();
                    JInternalFrame[] frames = desktop.getAllFrames();

                    for (int i = 0; i < frames.length; i++) {
                        String ftitle = frames[i].getTitle();

                        if (evaluate(ftitle, m_title)) {
                            if (getDebug()) {
                                System.err.println("JInternalFrame(" + dsk
                                    + "," + idx + ")" + frames[i].getTitle());
                            }

                            if (idx == index) {
                                return frames[i];
                            }

                            idx++;
                        }
                    }

                    dsk++;
                }
            }

            pause(date);
        } while (System.currentTimeMillis() < date);

        if (getDebug()) {
            System.err.print("Frame not found");
        }

        return null;
    }
}
