package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;


/**
 * This is a extension of the findTagHandler element. Where the
 * finder specified is JWindowFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This class is provided here mainly for completeness.
 *   This finder does not allow for finding specific window
 *   by a index. Not sure how useful this is. Might be replaceable
 *   with ComponentFinder using a class of JWindow.
 * </p>
 * <p>
 *   This class may be depricated in the future.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * JWindowFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to JWindowFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;JWindowFinder&quot;
 *    id=&quot;Window&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the first window and identifies it as &quot;Window&quot;
 * </p>
 * @see junit.extensions.jfcunit.finder.JWindowFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class JWindowFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for ComponentFinderTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public JWindowFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();
        findWindow(new JWindowFinder());
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException when errors encountered processing XML.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();
    }
}
