package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;


/**
 * This is a extension of the findTagHandler element. Where the
 * finder specified is LabeledComponentFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a LabeledComponentFinder and executes the find.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * ComponentFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to LabeledComponentFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">Container ID</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Search in all windows</td>
 *     <td valign="top">Panel to be searched</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">The index of the element to select from the combo box.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">Zero based index of list items.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">label</td>
 *     <td valign="top">The label text associated with the component.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">None</td>
 *     <td valign="top">Regular expression to match the label text.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">caseindependent</td>
 *     <td valign="top">True if case should be ignored.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">true</td>
 *     <td valign="top">true/false</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;LabeledComponentFinder&quot;
 *    id=&quot;MyLogin&quot;
 *    refid=&quot;MyPanel&quot;
 *    index=&quot;0&quot;
 *    label=&quot;Login:&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the first occurance of a component associated with a
 * label matching the "Login:" within the panel previously identified by
 * MyPanel. The name of the component will be MyLogin.
 * </p>
 * @see junit.extensions.jfcunit.finder.LabeledComponentFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class LabeledComponentFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for ComponentFinderTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public LabeledComponentFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException if the LABEL is not present.
     */
    public void processElement() throws XMLException {
        validateElement();

        String  label    = getLabel();
        boolean caseSens = super.getCaseIndependent();

        find(new LabeledComponentFinder(label, caseSens));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException if LABEL is not present.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: class
        checkRequiredAttribute(LABEL);
    }
}
