package junit.extensions.jfcunit.javatest;

import junit.extensions.jfcunit.JFCTestCase;

import java.awt.AWTEvent;
import java.awt.Robot;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;


/**
 * <p>Title: Test The robot.</p>
 * <p>Description: </p>
 * <p>Copyright: Copyright (c) 2003</p>
 * <p>Company: JFCUnit </p>
 * @author Kevin Wilson
 * @version 1.0
 */
public class RobotTest extends JFCTestCase {
    /** Robot to be used for test. */
    private Robot m_robot = null;

    /** lastx location of mouse. */
    private int m_lastx = -1;

    /** lasty location of mouse. */
    private int m_lasty = -1;

    /** Constructor. */
    public RobotTest() {
    }

    /**
     * Constructor.
     * @param name Name of the test case.
     */
    public RobotTest(final String name) {
        super(name);
    }

    /**
     * Setup the test case.
     * @throws Exception may be thrown.
     */
    public void setUp() throws Exception {
        super.setUp();
        m_robot = new Robot();
    }

    /**
     * Run the test.
     * @param args arguments to the main method.
     */
    public static void main(final String[] args) {
        RobotTest robotTest1 = new RobotTest();
    }

    /**
     * Test the mouse click. Not implemented.
     * @throws Throwable may be thrown.
     */
    public void testRobotClick() throws Throwable {
    }

    /**
     * Test sending in keys to the robot. Not implemented.
     * @throws Throwable may be thrown.
     */
    public void testRobotKey() throws Throwable {
    }

    /**
     * Test the mouse move of the robot.
     * @throws Throwable may be thrown.
     */
    public void testRobotMove() throws Throwable {
        java.awt.Frame frame = new java.awt.Frame();
        frame.setSize(600, 600);
        frame.setLocation(0, 0);
        frame.setVisible(true);
        frame.requestFocus();
        java.awt.Toolkit.getDefaultToolkit().addAWTEventListener(
            new AWTEventListener() {
                public void eventDispatched(final AWTEvent e) {
                    if (!(e instanceof MouseEvent)) {
                        return;
                    }

                    MouseEvent me = (MouseEvent) e;
                    m_lastx     = me.getPoint().x;
                    m_lasty     = me.getPoint().y;
                }
            },
            java.awt.event.MouseEvent.MOUSE_MOVED);

        for (int x = 0; x < 600; x += 5) {
            for (int y = 0; y < 600; y += 5) {
                m_lastx     = -1;
                m_lasty     = -1;
                m_robot.mouseMove(x, y);

                if (m_lastx != -1) {
                    assertEquals("X location:", x, m_lastx);
                    assertEquals("Y location:", y, m_lasty);
                }
            }
        }
    }
}
