package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;assertnotnull&gt; nodes.
 * Insures that the actualobject specified is not null.
 *
 * <H3>Summary</H3>
 * assertnotnull [message="message text"] actualrefid="id"|actualobject="value"
 *
 * <H3>One of the following attributes is required:</H3>
 *   actualrefid  id of object to be checked.<br>
 *   actualobject Value to be check.
 *
 * <H3>Optional Attributes:</H3>
 *   message       Optional message text to be specified.
 *
 * <H3>Depricated Attributes:</H3>
 * The following attributes have been depricated:<br>
 *   refid replaced by actualrefid
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AssertNotNullTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertNotNullTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AssertNotNullTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * The actual value is obtained and then asserted to
     * insure that the value is not null.
     *
     * @throws XMLException may be thrown.
     */
    public void processElement() throws XMLException {
        validateElement();

        String tagName = getElement().getNodeName();
        Assert.assertNotNull(
            getMessage(),
            getActualObject());
    }

    /**
     * Insure that the element contains a actual attribute.
     * @throws XMLException if this tag handler does not have the required
     * attributes.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: refid
        checkActual();
    }
}
