/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;

import java.awt.Component;


/**
 * Provide a mechanism for sending debug messages to the
 * test case developer.
 *
 * <H3>Tag Name</H3>
 * getparent
 * <H3>Attributes</H3>
 * <pre>
 * id - the to assign to parent object     [required]
 * refid - the id of the root object       [required]
 * classname - the classname of the parent [required]
 * </pre>
 * <H3>Examples</H3>
 * &lt;getparent id="parentId" refid="childID" classname="javax.swing.JPanel"/&gt;
 * @author Kevin Wilson
 */
public class ParentInstanceTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testcase parent test case.
     */
    public ParentInstanceTagHandler(final Element element,
        final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Handle the XML processing of the tag 'getparent'.
     * @throws XMLException upon failure of processing.
     */
    public void processElement() throws XMLException {
        validateElement();

        String refid     = getString(REFID);
        String id        = getString(ID);
        String classname = getString(CLASSNAME);

        Object o = getXMLTestCase().getProperty(refid);

        if (!(o instanceof Component)) {
            throw new XMLException("object not a component:" + o, null,
                getElement(),
                getXMLTestCase().getPropertyCache());
        }

        Class cls;

        try {
            cls = Class.forName(classname);
        } catch (ClassNotFoundException ex) {
            throw new XMLException("Cannot find class:" + classname, ex,
                getElement(),
                getXMLTestCase().getPropertyCache());
        }

        Component comp = ((Component) o).getParent();

        while (comp != null) {
            if (cls.isAssignableFrom(comp.getClass())) {
                getXMLTestCase().addProperty(id, comp);

                return;
            }

            comp = comp.getParent();
        }

        getXMLTestCase().addProperty(id, null);
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // message is a required attribute
        checkRequiredAttribute(ID);
        checkRequiredAttribute(REFID);
        checkRequiredAttribute(CLASSNAME);
    }
}
