package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTestCase;

import junit.framework.Test;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;test&gt; nodes.
 * <H3>Tag Name</H3>
 * test
 *
 * <H3>Required Attributes</H3>
 * name - Name of the test case.
 * <H3>Optional Attributes</H3>
 * Other attributes may be processed by the IXMLTestCase implementation.
 *
 * <H3>Children</H3>
 * Each of the children elements are processed by the corresponding
 * tag handler.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class TestTagHandler extends AbstractTagHandler {
    /**
     * Test Case.
     */
    protected Test m_testCase = null;

    /**
     * Constructor for TestTagHandler.
     *
     * @param element     The element to be processed
     * @param testSuite   The XMLTestSuite that uses this element
     */
    public TestTagHandler(final Element element, final IXMLTestSuite testSuite) {
        super(element, testSuite);
        validateElement();
        addTest();
    }

    /**
     * Process the children of the test case.
     * @throws XMLException may be thrown.
     */
    public void processElement() throws XMLException {
    }

    /**
     * Validate that the tag name is test.
     * @throws XMLException if the tag name is not test.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // check the element tag name
        checkElementTagName(TEST);
        checkRequiredAttribute(NAME);
    }

    /**
     * Returns the value of the NAME attribute for this element.
     * @return String  The value of the NAME attribute.
     */
    protected String getName() {
        return getString(NAME);
    }

    /**
     * This method is intended to be overridden when extending the
     * class for other test types.
     * @return Test New test instance.
     */
    protected Test createTest() {
        return new XMLTestCase(
            getName(),
            getElement());
    }

    /**
     * Add a test to the parent test suite.
     */
    private void addTest() {
        m_testCase = createTest();
        getXMLTestSuite().addTest(m_testCase);
    }
}
