/*
 * InfluxDB OSS API Service
 * The InfluxDB v2 API provides a programmatic interface for all interactions with InfluxDB. Access the InfluxDB API using the `/api/v2/` endpoint. 
 *
 * OpenAPI spec version: 2.0.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package com.influxdb.client;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

import javax.annotation.Nonnull;

import com.influxdb.client.domain.*;
import com.influxdb.utils.Arguments;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.bind.util.ISO8601Utils;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;

public class JSON {
    private Gson gson;

    public static GsonBuilder createGson() {
        GsonBuilder builder = new GsonBuilder();
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(Check.class,
                new LinkedHashMap<String, Class<? extends Check>>() {{
                    put("deadman", DeadmanCheck.class);
                    put("threshold", ThresholdCheck.class);
                    put("custom", CustomCheck.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(CheckDiscriminator.class,
                new LinkedHashMap<String, Class<? extends CheckDiscriminator>>() {{
                    put("deadman", DeadmanCheck.class);
                    put("threshold", ThresholdCheck.class);
                    put("custom", CustomCheck.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(NotificationEndpoint.class,
                new LinkedHashMap<String, Class<? extends NotificationEndpoint>>() {{
                    put("slack", SlackNotificationEndpoint.class);
                    put("pagerduty", PagerDutyNotificationEndpoint.class);
                    put("http", HTTPNotificationEndpoint.class);
                    put("telegram", TelegramNotificationEndpoint.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(NotificationEndpointDiscriminator.class,
                new LinkedHashMap<String, Class<? extends NotificationEndpointDiscriminator>>() {{
                    put("slack", SlackNotificationEndpoint.class);
                    put("pagerduty", PagerDutyNotificationEndpoint.class);
                    put("http", HTTPNotificationEndpoint.class);
                    put("telegram", TelegramNotificationEndpoint.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(NotificationRule.class,
                new LinkedHashMap<String, Class<? extends NotificationRule>>() {{
                    put("slack", SlackNotificationRule.class);
                    put("smtp", SMTPNotificationRule.class);
                    put("pagerduty", PagerDutyNotificationRule.class);
                    put("http", HTTPNotificationRule.class);
                    put("telegram", TelegramNotificationRule.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(NotificationRuleDiscriminator.class,
                new LinkedHashMap<String, Class<? extends NotificationRuleDiscriminator>>() {{
                    put("slack", SlackNotificationRule.class);
                    put("smtp", SMTPNotificationRule.class);
                    put("pagerduty", PagerDutyNotificationRule.class);
                    put("http", HTTPNotificationRule.class);
                    put("telegram", TelegramNotificationRule.class);
                }}));
        
        builder.registerTypeAdapterFactory(new DiscriminatorAdapter<>(Threshold.class,
                new LinkedHashMap<String, Class<? extends Threshold>>() {{
                    put("greater", GreaterThreshold.class);
                    put("lesser", LesserThreshold.class);
                    put("range", RangeThreshold.class);
                }}));
        
        return builder;
    }

    public JSON() {
        DateTypeAdapter dateTypeAdapter = new DateTypeAdapter();
        SqlDateTypeAdapter sqlDateTypeAdapter = new SqlDateTypeAdapter();
        OffsetDateTimeTypeAdapter offsetDateTimeTypeAdapter = new OffsetDateTimeTypeAdapter();
        LocalDateTypeAdapter localDateTypeAdapter = new LocalDateTypeAdapter();

        gson = createGson()
            .registerTypeAdapter(Date.class, dateTypeAdapter)
            .registerTypeAdapter(java.sql.Date.class, sqlDateTypeAdapter)
            .registerTypeAdapter(OffsetDateTime.class, offsetDateTimeTypeAdapter)
            .registerTypeAdapter(LocalDate.class, localDateTypeAdapter)
            .create();
    }

    /**
     * Get Gson.
     *
     * @return Gson
     */
    public Gson getGson() {
        return gson;
    }

    /**
     * Set Gson.
     *
     * @param gson Gson
     * @return JSON
     */
    public JSON setGson(Gson gson) {
        this.gson = gson;
        return this;
    }

    /**
     * Gson TypeAdapter for JSR310 OffsetDateTime type
     */
    public static class OffsetDateTimeTypeAdapter extends TypeAdapter<OffsetDateTime> {

        private static final OffsetDateTime ZERO = LocalDateTime.of(0, 1, 1, 0, 0)
                .atOffset(ZoneOffset.UTC);

        private DateTimeFormatter formatter;

        public OffsetDateTimeTypeAdapter() {
            this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }

        public OffsetDateTimeTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, OffsetDateTime date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                if (date.getYear() > 9999 || date.isBefore(ZERO)) {
                    // https://tools.ietf.org/html/rfc3339
                    throw new JsonIOException("OffsetDateTime is out of range. All dates and times are assumed to be "
                            + "in the \"current era\", somewhere between 0000AD and 9999AD.");
                }

                out.value(formatter.format(date));
            }
        }

        @Override
        public OffsetDateTime read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    if (date.endsWith("+0000")) {
                        date = date.substring(0, date.length() - 5) + "Z";
                    }
                    return OffsetDateTime.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for JSR310 LocalDate type
     */
    public class LocalDateTypeAdapter extends TypeAdapter<LocalDate> {

        private DateTimeFormatter formatter;

        public LocalDateTypeAdapter() {
            this(DateTimeFormatter.ISO_LOCAL_DATE);
        }

        public LocalDateTypeAdapter(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void setFormat(DateTimeFormatter dateFormat) {
            this.formatter = dateFormat;
        }

        @Override
        public void write(JsonWriter out, LocalDate date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                out.value(formatter.format(date));
            }
        }

        @Override
        public LocalDate read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    return LocalDate.parse(date, formatter);
            }
        }
    }

    /**
     * Gson TypeAdapter for java.sql.Date type
     * If the dateFormat is null, a simple "yyyy-MM-dd" format will be used
     * (more efficient than SimpleDateFormat).
     */
    public static class SqlDateTypeAdapter extends TypeAdapter<java.sql.Date> {

        private DateFormat dateFormat;

        public SqlDateTypeAdapter() {
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, java.sql.Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = date.toString();
                }
                out.value(value);
            }
        }

        @Override
        public java.sql.Date read(JsonReader in) throws IOException {
            switch (in.peek()) {
                case NULL:
                    in.nextNull();
                    return null;
                default:
                    String date = in.nextString();
                    try {
                        if (dateFormat != null) {
                            return new java.sql.Date(dateFormat.parse(date).getTime());
                        }
                        return new java.sql.Date(ISO8601Utils.parse(date, new ParsePosition(0)).getTime());
                    } catch (ParseException e) {
                        throw new JsonParseException(e);
                    }
            }
        }
    }

    /**
     * Gson TypeAdapter for java.util.Date type
     * If the dateFormat is null, ISO8601Utils will be used.
     */
    public static class DateTypeAdapter extends TypeAdapter<Date> {

        private DateFormat dateFormat;

        public DateTypeAdapter() {
        }

        public void setFormat(DateFormat dateFormat) {
            this.dateFormat = dateFormat;
        }

        @Override
        public void write(JsonWriter out, Date date) throws IOException {
            if (date == null) {
                out.nullValue();
            } else {
                String value;
                if (dateFormat != null) {
                    value = dateFormat.format(date);
                } else {
                    value = ISO8601Utils.format(date, true);
                }
                out.value(value);
            }
        }

        @Override
        public Date read(JsonReader in) throws IOException {
            try {
                switch (in.peek()) {
                    case NULL:
                        in.nextNull();
                        return null;
                    default:
                        String date = in.nextString();
                        try {
                            if (dateFormat != null) {
                                return dateFormat.parse(date);
                            }
                            return ISO8601Utils.parse(date, new ParsePosition(0));
                        } catch (ParseException e) {
                            throw new JsonParseException(e);
                        }
                }
            } catch (IllegalArgumentException e) {
                throw new JsonParseException(e);
            }
        }
    }

    @SuppressWarnings("unchecked")
    static final class DiscriminatorAdapter<T> implements TypeAdapterFactory {
        private final Class<?> type;
        private final Map<String, Class<? extends T>> subTypes;
        private TypeAdapter<?> cachedAdapter;

        DiscriminatorAdapter(@Nonnull final Class<T> type,
							 @Nonnull final Map<String, Class<? extends T>> subTypes) {
            Arguments.checkNotNull(type, "type");
            Arguments.checkNotNull(subTypes, "subTypes");
            this.type = type;
            this.subTypes = subTypes;
        }

        @Override
        public <R> TypeAdapter<R> create(Gson gson, TypeToken<R> type) {
            if (type == null) {
                return null;
            }

            if (!this.type.isAssignableFrom(type.getRawType())) {
                return null;
            }

            if (cachedAdapter == null) {
                cachedAdapter = new InnerDiscriminatorAdapter<R>(gson).nullSafe();
            }

            return (TypeAdapter<R>) cachedAdapter;
        }

        private class InnerDiscriminatorAdapter<R> extends TypeAdapter<R> {
            private final Gson gson;
            private final TypeAdapter<JsonElement> jsonAdapter;
            private final Map<String, TypeAdapter<?>> cachedSubtypesReadAdapters;
            private final Map<Class<?>, TypeAdapter<?>> cachedSubtypesWriteAdapters;

            InnerDiscriminatorAdapter(@Nonnull final Gson gson) {
                Arguments.checkNotNull(gson, "gson");

                this.gson = gson;
                this.jsonAdapter = gson.getAdapter(JsonElement.class);
                this.cachedSubtypesReadAdapters = new LinkedHashMap<>();
                this.cachedSubtypesWriteAdapters = new LinkedHashMap<>();

                for (Map.Entry<String, Class<? extends T>> entry : subTypes.entrySet()) {
                    TypeAdapter<?> adapter = gson.getDelegateAdapter(DiscriminatorAdapter.this,
                            TypeToken.get(entry.getValue()));
                    cachedSubtypesReadAdapters.put(entry.getKey(), adapter);
                    cachedSubtypesWriteAdapters.put(entry.getValue(), adapter);
                }
            }

            @Override
            public R read(JsonReader in) throws IOException {
                JsonObject json = jsonAdapter.read(in).getAsJsonObject();
                JsonElement discriminatorJson = json.get("type");

                if (discriminatorJson == null) {
                    String msg = String.format("Cannot find JSON field 'type' for %s adapter. JSON value: '%s'",
                            DiscriminatorAdapter.this.type, json);
                    throw new JsonParseException(msg);
                }

                String discriminator = discriminatorJson.getAsString();
                TypeAdapter<R> adapter = (TypeAdapter<R>) cachedSubtypesReadAdapters.get(discriminator);
                if (adapter == null) {
                    String msg = String.format("Cannot find model: '%s' for discriminator: '%s'. "
                            + "The discriminator wasn't registered.", discriminator, DiscriminatorAdapter.this.type);
                    throw new JsonParseException(msg);
                }
                return adapter.fromJsonTree(json);
            }

            @Override
            public void write(JsonWriter out, R value) throws IOException {
                Class<?> outputType = value.getClass();
                TypeAdapter<R> adapter = (TypeAdapter<R>) cachedSubtypesWriteAdapters.get(outputType);

                if (adapter == null) {
                    adapter = (TypeAdapter<R>) gson.getDelegateAdapter(DiscriminatorAdapter.this,
                            TypeToken.get(outputType));
                    cachedSubtypesWriteAdapters.put(type, adapter);
                }

                jsonAdapter.write(out, adapter.toJsonTree(value).getAsJsonObject());
            }
        }
    }
}
