package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;

import java.awt.Component;


/**
 * This is a extension of the FindTagHandler element. Where the
 * finder specified is JPopupMenuFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a JPopupMenuFinder and executes the find.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * JPopupMenuFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to JPopupMenuFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">ID of the component to be searched.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Search in all windows</td>
 *     <td valign="top">Panel to be searched</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">The index of the element to select from the combo box.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">Zero based index of list items.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">invokerid</td>
 *     <td valign="top">The id of the invoking Component</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">None</td>
 *     <td valign="top">property id of the invoking Component</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;JPopupMenuFinder&quot;
 *    id=&quot;MyPopup&quot;
 *    invokerid=&quot;MyComponent&quot;
 *    index=&quot;0&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the Popup menu associated with the invoker.
 * a text &quot;My label&quot;
 * </p>
 * @see junit.extensions.jfcunit.finder.JLabelFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class JPopupMenuFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for FindTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public JPopupMenuFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     */
    public void processElement() throws XMLException {
        validateElement();

        String invokerId = getString("invokerid");
        Object o = getTest().getProperty(invokerId);

        if ((o == null) || !(o instanceof Component)) {
            throw new XMLException("Object not Component" + o,
                getElement());
        } else {
            find(new JPopupMenuFinder((Component) o));
        }
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: label
        checkRequiredAttribute("invokerid");
    }
}
