package junit.extensions.jfcunit.finder;

import java.awt.Component;

import javax.swing.JWindow;


/**
 * Class for checking if the component being searched for has been found
 * The pattern syntax can be found at the Jakarta RegExp API Documentation in {@link org.apache.regexp.RE}.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class JWindowFinder extends AbstractWindowFinder {
    /**
     * Constructor accepting all arguments needed to filter component.
     * Since a JWindow does not have any attribute that can be used for filtering,
     * the "default" constructor inherited from AbstractWindowFinder is "hidden".
     */
    public JWindowFinder() {
        super(null, true);
    }

    /**
     * Method that returns true if the given component matches the search
     * criteria.
     *
     * @param comp   The component to test
     * @return true if this component is a match
     */
    public boolean testComponent(final Component comp) {
        return ((comp != null) && isValidForProcessing(comp, JWindow.class));
    }
}
