package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;assertnull&gt; nodes.
 * Insures that the actualobject specified is null.
 *
 * <H3>Summary</H3>
 * &lt;assertnull [message="message text"] actualrefid="id"|actualobject="value"/&gt;
 * <H3>One of the following attributes are required:</H3>
 *   actualrefid  id of object to be checked.<br>
 *   actualobject Value to be check.
 *
 * <H3>Optional Attributes:</H3>
 *   message       Optional message text to be specified.
 *
 * <H3>Depricated Attributes:</H3>
 * The following attributes have been depricated:<br>
 *   refid replaced by actualrefid
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AssertNullTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertNotTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AssertNullTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Assert that the actual object specified is null.
     * @throws XMLException is thrown upon assert.
     */
    public void processElement() throws XMLException {
        validateElement();
        Assert.assertNull(
            getMessage(),
            getActualObject());
    }

    /**
     * Insure that a actual attribute is present.
     * @throws XMLException if the required attribute is
     * missing.
     */
    public void validateElement() throws XMLException {
        super.validateElement();
        checkActual();
    }
}
