package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;assertsame&gt; nodes.
 * Insures that the actual and expected objects are the same.
 *
 * <H3>Summary</H3>
 * &lt;assertsame [message="message text"]
 * actualrefid="id"|actualobject="value"
 * expectedrefid="id"|expectedobject="value"/&gt;<br>
 *
 * <H3>One of the following attributes are required:</H3>
 * actualrefid  id of the object to be compared.<br>
 * actualobject value of the object to be compared.<br>
 *
 * <H3>One of the following attributes are required:</H3>
 * expectedrefid id of the object to be compared.<br>
 * expectedobject value of the object to be compared.<br>
 *
 * <H3>Optional Attributes:</H3>
 * message       Optional message text to be specified.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AssertSameTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertEqualsTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AssertSameTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Obtain the expected and actual values. Insure that the
     * values are refrenced to the same object. If not then
     * throw an assertion error.
     * @throws XMLException when the values do not reflect the
     * same object.
     */
    public void processElement() throws XMLException {
        validateElement();

        Assert.assertSame(
            getMessage(),
            getExpectedObject(),
            getActualObject());
    }

    /**
     * Insure that a actual and expected value are specified.
     * @throws XMLException when one of the required attributes are missing.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: at least one of expected or expectedrefid
        checkExpected();
        checkActual();
    }
}
