package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This tag handler forces the test case to fail by throwing a
 * AssertFailError from the test case.
 * <H3>Summary</H3>
 * fail [message="message text"]
 * <H3>Attributes</H3>
 *  message - message is a optional attribute which may be specified.
 *  The message text is reported in the assertion error thrown.<p><p>
 * @author Kevin Wilson
 */
public class FailTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertNotNullTagHandler.
     *
     * @param element     The element to be processed.
     * @param testCase    The IXMLTestCase that uses this element.
     */
    public FailTagHandler(final Element element, final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement().
     * @throws XMLException This method allways throws a AssertionFailError(message).
     */
    public void processElement() throws XMLException {
        validateElement();
        Assert.fail(getMessage());
    }
}
