/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.IXMLTestSuite;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;


/**
 * Create a property by the name given name.
 *
 * <H3>Tag Name</H3>
 * property
 * <H3>Attributes</H3>
 * name - name of the property<p>
 * value - value of the property<p>
 * <H3>Examples</H3>
 * Create a property in the current scope.
 * <pre>
 * &lt;property name="Myproperty" value="true"/&gt;
 * </pre>
 *
 * Create a property in the parent scope.
 * <pre>
 * &lt;property name="../Myproperty" value="true"/&gt;
 * </pre>
 * @author JFCUnit contributor
 */
public class PropertyTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testcase parent test case.
     */
    public PropertyTagHandler(final Element element, final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param suite parent test case.
     */
    public PropertyTagHandler(final Element element, final IXMLTestSuite suite) {
        super(element, suite);
    }

    /**
     * Handle the XML processing of the tag 'property'.
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        String name  = getString(NAME);
        String value = getString(VALUE);

        if (getXMLTestCase() != null) {
            getXMLTestCase().addProperty(name, value);
        } else {
            getXMLTestSuite().addProperty(name, value);
        }
    }

    /**
     * Make sure the appropriate tag and attributes are used.
     * @throws XMLException when validation fails.
     */
    public void validateElement() throws XMLException {
        super.validateElement();

        // message is a required attribute
        checkRequiredAttribute(NAME);
        checkRequiredAttribute(VALUE);
    }
}
