package junit.extensions.jfcunit.eventdata;

import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.jfcunit.xml.JFCXMLTestCase;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLUtil;
import junit.extensions.xml.elements.AbstractTagHandler;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import java.awt.Point;

import java.text.MessageFormat;

import java.util.Vector;


/**
 * This class will handle the processing of &lt;click&gt; nodes.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class DragTagHandler extends AbstractTagHandler
    implements JFCXMLConstants {
    /**
     * Constructor for ClickTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public DragTagHandler(final Element element, final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException when element cannot be properly parsed.
     */
    public void processElement() throws XMLException {
        validateElement();

        AbstractMouseEventData source = null;
        AbstractMouseEventData dest   = null;
        Vector                 points = new Vector();
        JFCXMLTestCase         tc     = (JFCXMLTestCase) getTestCase();

        // now we are ready to handle each individual node/element
        // Get the children and add to the suite.
        NodeList children = getElement().getChildNodes();
        Element  child;

        for (int i = 0; i < children.getLength(); i++) {
            if (children.item(i) instanceof Element) {
                child = (Element) children.item(i);

                String name = child.getTagName();

                if (name.equals(POINT)) {
                    String        data = XMLUtil.getAttribute(child, REFERENCE);
                    MessageFormat mf = new MessageFormat("{0},{1}");
                    int           x  = 0;
                    int           y  = 0;

                    try {
                        Object[] obs = mf.parse(data);
                        x     = Integer.parseInt((String) obs[0]);
                        y     = Integer.parseInt((String) obs[1]);
                    } catch (Exception ex) {
                        throw new XMLException("Could not parse the point:"
                            + data, ex,
                            getElement(),
                            getXMLTestCase().getPropertyCache());
                    }

                    points.add(new Point(x, y));
                }

                if (name.equals(DESTINATION)) {
                    if (dest != null) {
                        throw new XMLException("Destination specified twice",
                            null,
                            getElement(),
                            getXMLTestCase().getPropertyCache());
                    }

                    String                  type = XMLUtil.getAttribute(child,
                            TYPE);
                    BaseEventDataTagHandler th = (BaseEventDataTagHandler) XMLTagResourceBundle
                        .getTagHandler(
                            child,
                            getXMLTestCase(),
                            type);
                    dest = th.getEventData();
                }

                if (name.equals(SOURCE)) {
                    if (source != null) {
                        throw new XMLException("Source specified twice", null,
                            getElement(),
                            getXMLTestCase().getProcedureCache());
                    }

                    String                  type = XMLUtil.getAttribute(child,
                            TYPE);
                    BaseEventDataTagHandler th = (BaseEventDataTagHandler) XMLTagResourceBundle
                        .getTagHandler(
                            child,
                            getXMLTestCase(),
                            type);
                    source = th.getEventData();
                }
            }
        }

        if (source == null) {
            throw new XMLException("Source not specified in drag.", null,
                getElement(),
                getXMLTestCase().getPropertyCache());
        }

        // We have what we need to construct the event.
        DragEventData dragEvent = new DragEventData(tc, source, dest);

        if (points.size() > 0) {
            dragEvent.setPoints((Point[]) points.toArray(new Point[0]));
        }

        tc.getHelper().enterDragAndLeave(dragEvent);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException when element cannot be properly parsed.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();
    }

    /**
     * Returns the value of the TYPE attribute for this element.
     * @return String  The value of the TYPE attribute.
     */
    protected final String getType() {
        return getString(TYPE);
    }
}
