package junit.extensions.jfcunit.finder;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import org.w3c.dom.Element;

import javax.swing.Icon;


/**
 * This is a extension of the findTagHandler element. Where the
 * finder specified is AbstractButtonFinder.
 *
 * <h3>Description</h3>
 * <p>
 *   This creates a AbstractButtonFinder and executes the find.
 * </p>
 * <h3>Finder tag name</h3>
 * <p>
 * AbstractButtonFinder
 * </p>
 * <h3>Parameters</h3>
 * <table border="1" cellpadding="2" cellspacing="0">
 *   <tr>
 *     <td valign="top"><b>Attribute</b></td>
 *     <td valign="top"><b>Description</b></td>
 *     <td align="center" valign="top"><b>Required</b></td>
 *     <td valign="top"><b>Default</b></td>
 *     <td valign="top"><b>Values</b></td>
 *   </tr>
 *   <tr>
 *     <td valign="top">finder</td>
 *     <td valign="top">For this element the type must be set to AbstractButtonFinder</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">N/A</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">id</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">refid</td>
 *     <td valign="top">Id for the object found.</td>
 *     <td valign="top" align="center">No</td>
 *     <td valign="top">Search in all windows</td>
 *     <td valign="top">Panel to be searched</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">index</td>
 *     <td valign="top">The index of the element to select from the combo box.</td>
 *     <td valign="top" align="center">Yes</td>
 *     <td valign="top">N/A</td>
 *     <td valign="top">Zero based index of list items.</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">label</td>
 *     <td valign="top">The label of the button to be found.</td>
 *     <td valign="top" align="center">label or iconfile is required.</td>
 *     <td valign="top">None</td>
 *     <td valign="top">String</td>
 *   </tr>
 *   <tr>
 *     <td valign="top">iconfile</td>
 *     <td valign="top">The iconfile which is used as a icon on the button.</td>
 *     <td valign="top" align="center">label or iconfile is required.</td>
 *     <td valign="top">None</td>
 *     <td valign="top">Icon file name to be loaded and compared.</td>
 *   </tr>
 * </table>
 * <h3>Example</h3>
 * <blockquote><pre>
 * &lt;find
 *    finder=&quot;AbstractButtonFinder&quot;
 *    id=&quot;MyButton&quot;
 *    index=&quot;0&quot;
 *    label=&quot;My Button&quot;
 * /&gt;
 * </pre></blockquote>
 * <p>
 * The above finds the first occurance of a button with the label
 * &quot;My Button&quot;
 * </p>
 * @see junit.extensions.jfcunit.finder.AbstractButtonFinder
 * @author Kevin Wilson
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AbstractButtonFinderTagHandler extends BaseFindTagHandler {
    /**
     * Constructor for FindTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AbstractButtonFinderTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#processElement()
     * @throws XMLException is thrown if the element cannot be understood.
     */
    public void processElement() throws XMLException {
        validateElement();

        String  label           = getLabel();
        Icon    icon            = getIcon();
        boolean caseIndependent = getCaseIndependent();

        find(new AbstractButtonFinder(label, icon, caseIndependent));
    }

    /**
     * @see junit.extensions.xml.elements.AbstractTagHandler#validateElement()
     * @throws XMLException thrown if the element cannot be validated.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: at least one of label or icon file
        checkAtLeastOneRequiredAttribute(
            getElement(),
            new String[] {LABEL, ICONFILE});
    }
}
