package junit.extensions.jfcunit.finder;

import java.awt.Component;
import java.awt.Frame;


/**
 * Class for checking if the {@link java.awt.Component} being searched for has been found
 * The pattern syntax can be found at the Jakarta RegExp API Documentation in {@link org.apache.regexp.RE}.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class FrameFinder extends AbstractWindowFinder {
    /**
     * Constructor accepting all arguments needed to filter component.
     *
     * @param title    The desired pattern for the title of the component.
     */
    public FrameFinder(final String title) {
        super(title);
    }

    /**
     * Constructor accepting all arguments needed to filter a component ({@link Frame}).
     * @param title              The desired pattern for the title of the component.
     * @param caseIndependent    Whether the match should be case independent (true) or not (false)
     */
    public FrameFinder(final String title, final boolean caseIndependent) {
        super(title, caseIndependent);
    }

    /**
     * Method that returns true if the given {@link Component} matches the search
     * criteria.
     *
     * @param comp   The {@link Component} to test
     * @return true if this {@link Component} is a match
     */
    public boolean testComponent(final Component comp) {
        return ((comp != null) && isValidForProcessing(comp, Frame.class)
        && checkIfTitleMatches(((Frame) comp).getTitle()));
    }
}
