package junit.extensions.jfcunit.finder;

import java.awt.Component;
import javax.swing.JFileChooser;
import java.util.List;
import java.awt.Container;
import java.awt.Window;
import java.util.ArrayList;

/**
 * This class locates the JFileChooser with the given title.
 *
 * The container may be the window which owns the JFileChooser.
 * Owned windows will be explored.
 *
 * @author Kevin L Wilson
 */
public class JFileChooserFinder extends ComponentFinder {

    /** Title to be compared. */
    private String m_title;

    /**
     * Constructor accepting all arguments needed to filter component.
     *
     * @param title    The desired pattern for the title of the component.
     */
    public JFileChooserFinder(final String title) {
        super(JFileChooser.class);
        setTitle(title);
    }

    /**
     * Set the title to be matched.
     * @param title to be matched.
     */
    public final void setTitle(final String title) {
        m_title = title;
    }

    /**
     * Get the title to be matched.
     * @return title to be found.
     */
    public final String getTitle() {
        return m_title;
    }

    /**
     * Method that returns true if the given {@link java.awt.Component} matches the search
     * criteria.
     *
     * @param comp   The component to test
     * @return true if this component is a match
     */
    public boolean testComponent(final Component comp) {
        if (!super.testComponent(comp)) {
            return false;
        }
        if (m_title == null) {
            return true;
        }
        JFileChooser chooser = (JFileChooser) comp;
        String title = chooser.getDialogTitle();
        return this.evaluate(m_title, title);
    }

    /**
     * Find all of the components under the specified containers.
     * owned windows will also be explored.
     * @param conts Container[] to be searched.
     * @param index int index of chooser to return.
     * @return Component JFileChooser located.
     */
    public Component find(final Container[] conts, final int index) {
        List lst = findAll(conts, new ArrayList());
        if (lst.size() < index) {
            return null;
        }
        return (Component) lst.get(index);
    }

    /**
     * This findAll will also explore the owned windows
     * if a container is a window.
     *
     * @param cont Containers to be explored.
     * @param results items which have been found.
     * @return List result items.
     */
    protected List findAll(final Container[] cont, final List results) {
        for (int i = 0; i < cont.length; i++) {
            findComponentList(this, cont[i], results, Integer.MAX_VALUE);
            if (cont[i] instanceof Window) {
                findAll(((Window) cont[i]).getOwnedWindows(), results);
            }
        }
        return results;
    }

}
