package junit.extensions.jfcunit.keyboard;


/**
 * Interface for implementing character to
 * keyboard code mappings.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public interface KeyMapping {
    /**
     * Get the key strokes for a character.
     *
     * @param c The character to be coded.
     * @return Array of key strokes.
     */
    JFCKeyStroke[] getKeyStrokes(char c);

    /**
     * Get the key strokes for the key code.
     *
     * @param keyCode Key code to return the strokes for.
     * @return Array of key strokes.
     */
    JFCKeyStroke[] getKeyStrokes(int keyCode);
}
