package junit.extensions.xml;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * XMLProcedure Interface for containing the procedure.
 *
 * @author Kevin Wilson
 */
public class XMLProcedure implements IXMLProcedure, XMLConstants {
    /**
     * Element of the procedure definition.
     */
    private Element m_element;

    /**
     * Constructor.
     * @param e Element must be a procedure definition.
     */
    public XMLProcedure(final Element e) {
        m_element = e;
        Assert.assertNotNull(
            "Procedure name not specified",
            getName());
    }

    /**
     * Get the Element containing the procedure.
     * @return Element containting the procedure.
     */
    public Element getElement() {
        return m_element;
    }

    /**
     * Get the name for the test case.
     * @return name of the test case.
     */
    public String getName() {
        return XMLUtil.getAttribute(m_element, NAME);
    }
}
