package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;

import junit.framework.Assert;

import org.w3c.dom.Element;


/**
 * This class will handle the processing of &lt;assertnotequal&gt; nodes.
 * Insures that the actual and expected objects are not equal.
 *
 * <H3>Summary</H3>
 * assertnotequal [message="message text"] actualrefid="id"|actualobject="value"
 *  expectedrefid="id expectedobject="value"
 *<H3>One of the following attributes is required:</H3>
 *   actualrefid  id of the object to be compared.<p>
 *   actualobject value of the object to be compared.<p>
 *
 * <H3>One of the following attributes is required:</H3>
 *   expectedrefid id of the object to be compared.<p>
 *   expectedobject value of the object to be compared.<p>
 *
 * <H3>Optional Attributes:</H3>
 *   message       Optional message text to be specified.
 *
 * @author <a href="mailto:vraravam@thoughtworks.com">Vijay Aravamudhan : ThoughtWorks Inc.</a>
 */
public class AssertNotEqualsTagHandler extends AbstractAssertTagHandler {
    /**
     * Constructor for AssertEqualsTagHandler.
     *
     * @param element     The element to be processed
     * @param testCase    The IXMLTestCase that uses this element
     */
    public AssertNotEqualsTagHandler(final Element element,
        final IXMLTestCase testCase) {
        super(element, testCase);
    }

    /**
     * Obtain the expected and actual values. If the
     * compared values are not equal then assert.
     *
     * @throws XMLException when exception is thrown.
     */
    public void processElement() throws XMLException {
        validateElement();

        boolean assrt = false;

        try {
            Assert.assertEquals(
                getExpectedObject(),
                getActualObject());
        } catch (Throwable t) {
            assrt = true;
        }

        Assert.assertTrue(
            getMessage(),
            assrt);
    }

    /**
     * Insure that the expected and actual attributes are
     * specified.
     * @throws XMLException thrown if the expected or actual
     * values are not specified.
     */
    public void validateElement() throws XMLException {
        // do the default validations from the super class
        super.validateElement();

        // reqd attribute: at least one of expected or expectedrefid
        checkExpected();
        checkActual();
    }
}
