/*
 * Created on Oct 24, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package junit.extensions.xml.elements;

import junit.extensions.xml.IXMLTestCase;

import org.w3c.dom.Element;


/**
 * Provide a mechanism for turning off specific tag
 * handlers by changing the tag handler assignment.
 *
 *
 * <H3>Tag Name</H3>
 * noop
 * <H3>Examples</H3>
 * Simple usage
 * <pre>
 *  &lt;noop/&gt;
 * </pre>
 * Used as a tag hander to ignore user tags.
 * <pre>
 * &lt;taghandlers action="add" tagname="mytag" classname="junit.extensions.xml.elements.NoOpTagHandler/&gt;
 * </pre>
 * @author Kevin Wilson
 */
public class NoOpTagHandler extends AbstractTagHandler {
    /**
     * Constructor.
     * @param element Element to be processed by the tag handler.
     * @param testcase parent test case.
     */
    public NoOpTagHandler(final Element element, final IXMLTestCase testcase) {
        super(element, testcase);
    }

    /**
     * Handle the XML processing of the tag 'noop'.
     */
    public void processElement() {
    }
}
